/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.indexversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.indexversion.PurgeOldVersionUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexName;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexVersionOperation {
    private static final Logger LOG = LoggerFactory.getLogger(IndexVersionOperation.class);
    private IndexName indexName;
    private Operation operation;

    public IndexVersionOperation(IndexName indexName) {
        this.indexName = indexName;
        this.operation = Operation.NOOP;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public IndexName getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return this.getIndexName() + " operation:" + this.getOperation();
    }

    public List<IndexVersionOperation> generateIndexVersionOperationList(NodeState rootNode, String parentPath, List<IndexName> indexNameObjectList, long purgeThresholdMillis) {
        return this.generateIndexVersionOperationList(rootNode, parentPath, indexNameObjectList, purgeThresholdMillis, true);
    }

    public List<IndexVersionOperation> generateIndexVersionOperationList(NodeState rootNode, String parentPath, List<IndexName> indexNameObjectList, long purgeThresholdMillis, boolean shouldPurgeBaseIndex) {
        NodeState indexDefParentNode = NodeStateUtils.getNode((NodeState)rootNode, (String)parentPath);
        List<IndexName> reverseSortedIndexNameList = IndexVersionOperation.getReverseSortedIndexNameList(indexNameObjectList);
        LOG.info("Reverse Sorted list {} ", reverseSortedIndexNameList);
        List<IndexVersionOperation> indexVersionOperationList = new LinkedList<IndexVersionOperation>();
        List<IndexName> disableIndexNameObjectList = IndexVersionOperation.removeDisabledCustomIndexesFromList(indexDefParentNode, reverseSortedIndexNameList);
        reverseSortedIndexNameList.removeAll(disableIndexNameObjectList);
        LOG.info("Disabled index list {}, new reverse sorted list after removing disabled indexes{}", disableIndexNameObjectList, reverseSortedIndexNameList);
        for (IndexName indexNameObject : disableIndexNameObjectList) {
            String indexName = indexNameObject.getNodeName();
            NodeState indexNode = indexDefParentNode.getChildNode(PathUtils.getName((String)indexName));
            IndexVersionOperation indexVersionOperation = this.getIndexVersionOperationInstance(indexNameObject);
            if (this.checkIfDisabledIndexCanBeMarkedForDeletion(indexNode)) {
                indexVersionOperation.setOperation(Operation.DELETE);
            }
            indexVersionOperationList.add(indexVersionOperation);
        }
        if (!reverseSortedIndexNameList.isEmpty()) {
            IndexName activeIndexNameObject = this.getActiveIndex(reverseSortedIndexNameList, parentPath, rootNode);
            if (activeIndexNameObject == null) {
                LOG.warn("Cannot find any active index from the list: {}", reverseSortedIndexNameList);
            } else {
                if (!IndexVersionOperation.isSameProductVersionBaseIndexPresent(reverseSortedIndexNameList, activeIndexNameObject)) {
                    LOG.warn("Repository don't have base index:{} with product version same as active index:{}", (Object)(activeIndexNameObject.getBaseName() + "-" + activeIndexNameObject.getProductVersion()), (Object)activeIndexNameObject.toString());
                }
                NodeState activeIndexNode = indexDefParentNode.getChildNode(PathUtils.getName((String)activeIndexNameObject.getNodeName()));
                boolean isActiveIndexOldEnough = IndexVersionOperation.isActiveIndexOldEnough(activeIndexNameObject, activeIndexNode, purgeThresholdMillis);
                int activeProductVersion = activeIndexNameObject.getProductVersion();
                indexVersionOperationList.add(this.getIndexVersionOperationInstance(activeIndexNameObject));
                for (IndexName indexNameObject : reverseSortedIndexNameList) {
                    String indexName = indexNameObject.getNodeName();
                    NodeState indexNode = indexDefParentNode.getChildNode(PathUtils.getName((String)indexName));
                    IndexVersionOperation indexVersionOperation = this.getIndexVersionOperationInstance(indexNameObject);
                    if (isActiveIndexOldEnough) {
                        if (indexNameObject.getProductVersion() == activeProductVersion && indexNameObject.getCustomerVersion() == 0) {
                            if (shouldPurgeBaseIndex) {
                                indexVersionOperation.setOperation(Operation.DELETE_HIDDEN_AND_DISABLE);
                            } else {
                                indexVersionOperation.setOperation(Operation.NOOP);
                            }
                        } else if (indexNameObject.getProductVersion() <= activeProductVersion) {
                            if (IndexVersionOperation.isHiddenOakMountExists(indexNode)) {
                                LOG.info("Found hidden oak mount node for: '{}', disable it but no index definition deletion", (Object)indexName);
                                indexVersionOperation.setOperation(Operation.DELETE_HIDDEN_AND_DISABLE);
                            } else {
                                indexVersionOperation.setOperation(Operation.DELETE);
                            }
                        } else {
                            LOG.info("The index '{}' leave as is since the version is larger than current active index", (Object)indexName);
                            indexVersionOperation.setOperation(Operation.NOOP);
                        }
                    }
                    LOG.info("The operation for index '{}' will be: '{}'", (Object)indexName, (Object)indexVersionOperation.getOperation());
                    indexVersionOperationList.add(indexVersionOperation);
                }
            }
        }
        if (indexVersionOperationList.isEmpty()) {
            LOG.info("Not valid version operation list: '{}', skip all", indexNameObjectList);
            indexVersionOperationList = Collections.emptyList();
        }
        return indexVersionOperationList;
    }

    private static boolean isSameProductVersionBaseIndexPresent(List<IndexName> reverseSortedIndexNameList, IndexName activeIndexNameObject) {
        return reverseSortedIndexNameList.stream().filter(n -> n.getBaseName().equals(activeIndexNameObject.getBaseName()) && n.getProductVersion() == activeIndexNameObject.getProductVersion() && n.getCustomerVersion() == 0).findFirst().isPresent();
    }

    private static boolean isActiveIndexOldEnough(IndexName activeIndexName, NodeState activeIndexNode, long purgeThresholdMillis) {
        String indexName = activeIndexName.getNodeName();
        if (activeIndexNode.hasChildNode(":status")) {
            if (activeIndexNode.getChildNode(":status").getProperty("reindexCompletionTimestamp") != null) {
                String reindexCompletionTime = (String)activeIndexNode.getChildNode(":status").getProperty("reindexCompletionTimestamp").getValue(Type.DATE);
                long reindexCompletionTimeInMillis = PurgeOldVersionUtils.getMillisFromString(reindexCompletionTime);
                long currentTimeInMillis = System.currentTimeMillis();
                if (currentTimeInMillis - reindexCompletionTimeInMillis > purgeThresholdMillis) {
                    LOG.info("Found active index {} is old enough", (Object)indexName);
                    return true;
                }
                LOG.info("The last index time '{}' isn't old enough for: {}", (Object)reindexCompletionTime, (Object)indexName);
            } else {
                LOG.warn("{} property is not set for index {}", (Object)"reindexCompletionTimestamp", (Object)indexName);
            }
        }
        LOG.info("The active index '{}' indexing time isn't old enough", (Object)indexName);
        return false;
    }

    protected static boolean isHiddenOakMountExists(NodeState indexNode) {
        for (String nodeName : indexNode.getChildNodeNames()) {
            if (!nodeName.startsWith(":oak:mount-")) continue;
            return true;
        }
        return false;
    }

    private static List<IndexName> getReverseSortedIndexNameList(List<IndexName> indexNameObjectList) {
        ArrayList<IndexName> reverseSortedIndexNameObjectList = new ArrayList<IndexName>(indexNameObjectList);
        Collections.sort(reverseSortedIndexNameObjectList, Collections.reverseOrder());
        return reverseSortedIndexNameObjectList;
    }

    private static List<IndexName> removeDisabledCustomIndexesFromList(NodeState indexDefParentNode, List<IndexName> indexNameObjectList) {
        ArrayList<IndexName> disableIndexNameObjectList = new ArrayList<IndexName>();
        for (int i = 0; i < indexNameObjectList.size(); ++i) {
            NodeState indexNode = indexDefParentNode.getChildNode(PathUtils.getName((String)indexNameObjectList.get(i).getNodeName()));
            if (indexNode.getProperty("type") == null || !"disabled".equals(indexNode.getProperty("type").getValue(Type.STRING))) continue;
            disableIndexNameObjectList.add(indexNameObjectList.get(i));
        }
        return disableIndexNameObjectList;
    }

    protected abstract IndexVersionOperation getIndexVersionOperationInstance(IndexName var1);

    protected abstract boolean checkIfDisabledIndexCanBeMarkedForDeletion(NodeState var1);

    @Nullable
    protected abstract IndexName getActiveIndex(List<IndexName> var1, String var2, NodeState var3);

    static enum Operation {
        NOOP,
        DELETE_HIDDEN_AND_DISABLE,
        DELETE;

    }
}

