/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.indexversion;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.indexversion.IndexVersionOperation;
import org.apache.jackrabbit.oak.indexversion.PurgeOldVersionUtils;
import org.apache.jackrabbit.oak.plugins.index.CompositeIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexName;
import org.apache.jackrabbit.oak.plugins.index.IndexPathServiceImpl;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateProvider;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.reference.ReferenceEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PurgeOldIndexVersion
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeOldIndexVersion.class);
    protected final Closer closer = Closer.create();

    public void execute(NodeStore nodeStore, boolean isReadWriteRepository, long purgeThresholdMillis, List<String> indexPaths) throws IOException, CommitFailedException {
        this.execute(nodeStore, isReadWriteRepository, purgeThresholdMillis, indexPaths, true);
    }

    public void execute(NodeStore nodeStore, boolean isReadWriteRepository, long purgeThresholdMillis, List<String> indexPaths, boolean shouldPurgeBaseIndex) throws IOException, CommitFailedException {
        List<IndexVersionOperation> purgeIndexList = this.getPurgeIndexes(nodeStore, purgeThresholdMillis, indexPaths, shouldPurgeBaseIndex);
        if (!purgeIndexList.isEmpty()) {
            if (isReadWriteRepository) {
                LOG.info("Found indexes for purging: '{}'", purgeIndexList);
                long purgeStart = System.currentTimeMillis();
                this.purgeOldIndexVersion(nodeStore, purgeIndexList);
                LOG.info("Index purging done, took '{}' ms", (Object)(System.currentTimeMillis() - purgeStart));
            } else {
                LOG.info("Repository is opened in read-only mode, the purging indexes for '{}' are: {}", indexPaths, purgeIndexList);
            }
        } else {
            LOG.info("No indexes are found to be purged");
        }
    }

    public List<IndexVersionOperation> getPurgeIndexes(NodeStore nodeStore, long purgeThresholdMillis, List<String> indexPaths, boolean shouldPurgeBaseIndex) throws IOException, CommitFailedException {
        ArrayList<IndexVersionOperation> purgeIndexList = new ArrayList<IndexVersionOperation>();
        LOG.info("Getting indexes to purge over index paths '{}'", indexPaths);
        List<String> sanitisedIndexPaths = this.sanitiseUserIndexPaths(indexPaths);
        Set<String> indexPathSet = this.filterIndexPaths(nodeStore, this.getRepositoryIndexPaths(nodeStore), sanitisedIndexPaths);
        Map<String, Set<String>> segregateIndexes = this.segregateIndexes(indexPathSet);
        for (Map.Entry<String, Set<String>> entry : segregateIndexes.entrySet()) {
            String baseIndexPath = entry.getKey();
            String parentPath = PathUtils.getParentPath((String)baseIndexPath);
            List<IndexName> indexNameObjectList = this.getIndexNameObjectList(entry.getValue());
            LOG.info("Validate purge index over base of '{}', which includes: '{}'", (Object)baseIndexPath, indexNameObjectList);
            List<IndexVersionOperation> toDeleteIndexNameObjectList = this.getIndexVersionOperationInstance(IndexName.parse((String)baseIndexPath)).generateIndexVersionOperationList(nodeStore.getRoot(), parentPath, indexNameObjectList, purgeThresholdMillis, shouldPurgeBaseIndex);
            toDeleteIndexNameObjectList.removeIf(item -> item.getOperation() == IndexVersionOperation.Operation.NOOP);
            if (!toDeleteIndexNameObjectList.isEmpty()) {
                LOG.info("Found some index need to be purged over base'{}': '{}'", (Object)baseIndexPath, toDeleteIndexNameObjectList);
                purgeIndexList.addAll(toDeleteIndexNameObjectList);
                continue;
            }
            LOG.info("No index found to be purged over base: '{}'", (Object)baseIndexPath);
        }
        return purgeIndexList;
    }

    public List<IndexVersionOperation> getPurgeIndexes(NodeStore nodeStore, long purgeThresholdMillis, List<String> indexPaths) throws IOException, CommitFailedException {
        return this.getPurgeIndexes(nodeStore, purgeThresholdMillis, indexPaths, true);
    }

    private List<String> sanitiseUserIndexPaths(List<String> userIndexPaths) {
        ArrayList<String> sanitisedUserIndexPaths = new ArrayList<String>();
        for (String userIndexPath : userIndexPaths) {
            if (PathUtils.getName((String)userIndexPath).equals("oak:index")) {
                sanitisedUserIndexPaths.add(userIndexPath);
                continue;
            }
            if (PathUtils.getName((String)PathUtils.getParentPath((String)userIndexPath)).equals("oak:index")) {
                sanitisedUserIndexPaths.add(IndexName.parse((String)userIndexPath).getBaseName());
                continue;
            }
            throw new IllegalArgumentException(userIndexPath + " indexpath is not valid");
        }
        return sanitisedUserIndexPaths;
    }

    private Map<String, Set<String>> segregateIndexes(Set<String> indexPathSet) {
        HashMap<String, Set<String>> segregatedIndexes = new HashMap<String, Set<String>>();
        for (String path : indexPathSet) {
            String baseIndexPath = IndexName.parse((String)path).getBaseName();
            HashSet<String> indexPaths = (HashSet<String>)segregatedIndexes.get(baseIndexPath);
            if (indexPaths == null) {
                indexPaths = new HashSet<String>();
            }
            indexPaths.add(path);
            segregatedIndexes.put(baseIndexPath, indexPaths);
        }
        return segregatedIndexes;
    }

    private Iterable<String> getRepositoryIndexPaths(NodeStore store) throws CommitFailedException, IOException {
        IndexPathServiceImpl indexPathService = new IndexPathServiceImpl(store);
        return indexPathService.getIndexPaths();
    }

    private Set<String> filterIndexPaths(NodeStore store, Iterable<String> repositoryIndexPaths, List<String> commandlineIndexPaths) {
        HashSet<String> filteredIndexPaths = new HashSet<String>();
        NodeState root = store.getRoot();
        NodeBuilder rootBuilder = root.builder();
        for (String commandlineIndexPath : commandlineIndexPaths) {
            for (String repositoryIndexPath : repositoryIndexPaths) {
                String type;
                NodeBuilder nodeBuilder;
                if (!PurgeOldVersionUtils.isIndexChildNode(commandlineIndexPath, repositoryIndexPath) && !PurgeOldVersionUtils.isBaseIndexEqual(commandlineIndexPath, repositoryIndexPath) || !(nodeBuilder = PurgeOldVersionUtils.getNode(rootBuilder, repositoryIndexPath)).exists() || "disabled".equals(type = (String)nodeBuilder.getProperty("type").getValue(Type.STRING)) && (nodeBuilder.getProperty(":originalType") == null || !this.getIndexType().equals(nodeBuilder.getProperty(":originalType").getValue(Type.STRING))) || !"disabled".equals(type) && !this.getIndexType().equals(type)) continue;
                filteredIndexPaths.add(repositoryIndexPath);
            }
        }
        return filteredIndexPaths;
    }

    private List<IndexName> getIndexNameObjectList(Set<String> versionedIndexPaths) {
        ArrayList<IndexName> indexNameObjectList = new ArrayList<IndexName>();
        for (String indexNameString : versionedIndexPaths) {
            indexNameObjectList.add(IndexName.parse((String)indexNameString));
        }
        return indexNameObjectList;
    }

    private void purgeOldIndexVersion(NodeStore store, List<IndexVersionOperation> toDeleteIndexNameObjectList) throws CommitFailedException {
        for (IndexVersionOperation toDeleteIndexNameObject : toDeleteIndexNameObjectList) {
            String nodeName;
            NodeState root = store.getRoot();
            NodeBuilder rootBuilder = root.builder();
            NodeBuilder nodeBuilder = PurgeOldVersionUtils.getNode(rootBuilder, nodeName = toDeleteIndexNameObject.getIndexName().getNodeName());
            if (nodeBuilder.exists()) {
                String type = (String)nodeBuilder.getProperty("type").getValue(Type.STRING);
                ImmutableList indexEditorProviders = ImmutableList.of((Object)new ReferenceEditorProvider(), (Object)new PropertyIndexEditorProvider(), (Object)new NodeCounterEditorProvider());
                EditorHook hook = new EditorHook((EditorProvider)new IndexUpdateProvider(CompositeIndexEditorProvider.compose((Collection)indexEditorProviders)));
                if (toDeleteIndexNameObject.getOperation() == IndexVersionOperation.Operation.DELETE_HIDDEN_AND_DISABLE) {
                    LOG.info("Disabling {}", (Object)nodeName);
                    nodeBuilder.setProperty("type", (Object)"disabled", Type.STRING);
                    nodeBuilder.setProperty(":originalType", (Object)type, Type.STRING);
                    store.merge(rootBuilder, (CommitHook)hook, CommitInfo.EMPTY);
                    PurgeOldVersionUtils.recursiveDeleteHiddenChildNodes(store, nodeName);
                    continue;
                }
                if (toDeleteIndexNameObject.getOperation() != IndexVersionOperation.Operation.DELETE) continue;
                this.preserveDetailsFromIndexDefForPostOp(nodeBuilder);
                LOG.info("Deleting {}", (Object)nodeName);
                nodeBuilder.remove();
                store.merge(rootBuilder, (CommitHook)hook, CommitInfo.EMPTY);
                this.postDeleteOp(toDeleteIndexNameObject.getIndexName().getNodeName());
                continue;
            }
            LOG.error("nodebuilder null for path " + nodeName);
        }
    }

    @NotNull
    protected abstract String getIndexType();

    protected abstract void postDeleteOp(String var1);

    protected abstract void preserveDetailsFromIndexDefForPostOp(NodeBuilder var1);

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    protected abstract IndexVersionOperation getIndexVersionOperationInstance(IndexName var1);
}

