/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.indexversion;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexName;
import org.apache.jackrabbit.oak.plugins.index.property.RecursiveDelete;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;

public class PurgeOldVersionUtils {
    public static final String OAK_INDEX = "oak:index";

    public static long getMillisFromString(String strDate) {
        return ISO8601.parse((String)strDate).getTimeInMillis();
    }

    public static NodeBuilder getNode(@NotNull NodeBuilder nodeBuilder, @NotNull String path) {
        NodeBuilder resultNodeBuilder = nodeBuilder;
        for (String name : PathUtils.elements((String)((String)Preconditions.checkNotNull((Object)path)))) {
            resultNodeBuilder = resultNodeBuilder.getChildNode((String)Preconditions.checkNotNull((Object)name));
        }
        return resultNodeBuilder;
    }

    public static void recursiveDeleteHiddenChildNodes(NodeStore store, String path) throws CommitFailedException {
        NodeState nodeState = NodeStateUtils.getNode((NodeState)store.getRoot(), (String)path);
        Iterable childNodeNames = nodeState.getChildNodeNames();
        for (String childNodeName : childNodeNames) {
            if (!NodeStateUtils.isHidden((String)childNodeName) || childNodeName.startsWith(":oak:mount-")) continue;
            RecursiveDelete recursiveDelete = new RecursiveDelete(store, EmptyHook.INSTANCE, () -> CommitInfo.EMPTY);
            recursiveDelete.run(path + "/" + childNodeName);
        }
    }

    public static boolean isBaseIndexEqual(String commandlineIndexPath, String repositoryIndexPath) {
        String repositoryIndexBaseName;
        String commandlineIndexBaseName;
        return PathUtils.getName((String)PathUtils.getParentPath((String)commandlineIndexPath)).equals(OAK_INDEX) && (commandlineIndexBaseName = IndexName.parse((String)commandlineIndexPath).getBaseName()).equals(repositoryIndexBaseName = IndexName.parse((String)repositoryIndexPath).getBaseName());
    }

    public static boolean isIndexChildNode(String commandlineIndexPath, String repositoryIndexPath) {
        return PathUtils.getName((String)commandlineIndexPath).equals(OAK_INDEX) && repositoryIndexPath.startsWith(commandlineIndexPath);
    }
}

