/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreSplitter {
    private static final Logger log = LoggerFactory.getLogger(DocumentStoreSplitter.class);
    MongoDocumentStore mongoStore;

    public DocumentStoreSplitter(MongoDocumentStore mongoStore) {
        this.mongoStore = mongoStore;
    }

    public <T extends Document> List<Long> split(Collection<T> collection, long modifiedSinceLowerLimit, int parts) {
        long oldest;
        MongoCursor cursor;
        MongoCollection dbCollection = this.mongoStore.getDBCollection(collection);
        BsonDocument query = new BsonDocument();
        query.append("_modified", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonNull()));
        if (modifiedSinceLowerLimit <= 0L) {
            cursor = dbCollection.find((Bson)query).sort((Bson)new BsonDocument("_modified", (BsonValue)new BsonInt64(1L))).limit(1).iterator();
            if (!cursor.hasNext()) {
                return Collections.emptyList();
            }
            oldest = ((BasicDBObject)cursor.next()).getLong("_modified");
        } else {
            oldest = modifiedSinceLowerLimit;
        }
        cursor = dbCollection.find((Bson)query).sort((Bson)new BsonDocument("_modified", (BsonValue)new BsonInt64(-1L))).limit(1).iterator();
        if (!cursor.hasNext()) {
            return Collections.emptyList();
        }
        long latest = ((BasicDBObject)cursor.next()).getLong("_modified");
        return DocumentStoreSplitter.simpleSplit(oldest, latest, parts);
    }

    public static List<Long> simpleSplit(long start, long end, int parts) {
        if (end < start) {
            throw new IllegalArgumentException("start(" + start + ") can't be greater than end (" + end + ")");
        }
        if (start == end) {
            return Collections.singletonList(start);
        }
        if ((long)parts > end - start) {
            log.debug("Adjusting parts according to given range {} - {}", (Object)start, (Object)end);
            parts = (int)(end - start);
        }
        long stepSize = (end - start) / (long)parts;
        ArrayList<Long> steps = new ArrayList<Long>();
        StringBuilder splitPoints = new StringBuilder();
        for (long i = start; i <= end; i += stepSize) {
            steps.add(i);
            splitPoints.append(" ").append(i);
        }
        if (steps.size() > 0 && (Long)steps.get(steps.size() - 1) != end) {
            steps.add(end);
            splitPoints.append(" ").append(end);
        }
        log.info("Split points of _modified values {}", (Object)splitPoints.toString());
        return steps;
    }
}

