/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.io.Closeable;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.FluentIterable;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.TraversingRange;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentTraverser {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentTraverser.class);
    private final MongoDocumentStore mongoStore;
    private boolean disableReadOnlyCheck;

    public MongoDocumentTraverser(MongoDocumentStore mongoStore) {
        this.mongoStore = mongoStore;
    }

    public <T extends Document> CloseableIterable<T> getAllDocuments(Collection<T> collection, TraversingRange traversingRange, Predicate<String> filter) {
        FindIterable cursor;
        if (!this.disableReadOnlyCheck) {
            Preconditions.checkState((boolean)this.mongoStore.isReadOnly(), (Object)"Traverser can only be used with readOnly store");
        }
        MongoCollection dbCollection = this.mongoStore.getDBCollection(collection);
        if (traversingRange.coversAllDocuments()) {
            cursor = dbCollection.withReadPreference(this.mongoStore.getConfiguredReadPreference(collection)).find();
        } else {
            ReadPreference preference = this.mongoStore.getConfiguredReadPreference(collection);
            LOG.info("Using read preference {}", (Object)preference.getName());
            cursor = dbCollection.withReadPreference(preference).find((Bson)traversingRange.getFindQuery()).sort((Bson)new BsonDocument().append("_modified", (BsonValue)new BsonInt64(1L)).append("_id", (BsonValue)new BsonInt64(1L)));
        }
        CloseableIterable closeableCursor = CloseableIterable.wrap((Iterable)cursor);
        cursor = closeableCursor;
        FluentIterable result = FluentIterable.from((Iterable)cursor).filter(o -> filter.test((String)o.get("_id"))).transform(o -> {
            Document doc = this.mongoStore.convertFromDBObject(collection, (DBObject)o);
            if (collection == Collection.NODES) {
                NodeDocument nodeDoc = (NodeDocument)doc;
                this.getNodeDocCache().put(nodeDoc);
            }
            return doc;
        });
        return CloseableIterable.wrap((Iterable)result, (Closeable)closeableCursor);
    }

    void disableReadOnlyCheck() {
        this.disableReadOnlyCheck = true;
    }

    private NodeDocumentCache getNodeDocCache() {
        return this.mongoStore.getNodeDocumentCache();
    }
}

