/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import java.util.Objects;
import org.apache.jackrabbit.oak.index.indexer.document.LastModifiedRange;
import org.bson.BsonDocument;

public class TraversingRange {
    private final LastModifiedRange lastModifiedRange;
    private final String startAfterDocumentID;

    public TraversingRange(LastModifiedRange lastModifiedRange, String startAfterDocumentID) {
        this.lastModifiedRange = lastModifiedRange;
        this.startAfterDocumentID = startAfterDocumentID;
    }

    public boolean coversAllDocuments() {
        return this.lastModifiedRange.coversAllDocuments() && this.startAfterDocumentID == null;
    }

    public LastModifiedRange getLastModifiedRange() {
        return this.lastModifiedRange;
    }

    public BsonDocument getFindQuery() {
        String lastModifiedRangeQueryPart = "{$gte:" + this.lastModifiedRange.getLastModifiedFrom() + ",";
        lastModifiedRangeQueryPart = lastModifiedRangeQueryPart + "$lt:" + this.lastModifiedRange.getLastModifiedTo() + "}";
        Object idRangeQueryPart = "";
        if (this.startAfterDocumentID != null) {
            String condition = "{$gt:\"" + this.startAfterDocumentID + "\"}";
            idRangeQueryPart = ", _id:" + condition;
        }
        return BsonDocument.parse((String)("{_modified:" + lastModifiedRangeQueryPart + (String)idRangeQueryPart + "}"));
    }

    public String getStartAfterDocumentID() {
        return this.startAfterDocumentID;
    }

    public String toString() {
        return "Range: " + this.lastModifiedRange.toString() + ", startAfterDocument: " + this.startAfterDocumentID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraversingRange that = (TraversingRange)o;
        return Objects.equals(this.lastModifiedRange, that.lastModifiedRange) && Objects.equals(this.startAfterDocumentID, that.startAfterDocumentID);
    }

    public int hashCode() {
        return Objects.hash(this.lastModifiedRange, this.startAfterDocumentID);
    }
}

