/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.jackrabbit.oak.indexversion.PurgeOldIndexVersion;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixture;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixtureProvider;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.run.commons.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PurgeOldIndexVersionCommand
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeOldIndexVersionCommand.class);
    private long threshold;
    private List<String> indexPaths;
    private long DEFAULT_PURGE_THRESHOLD = TimeUnit.DAYS.toMillis(5L);
    private static final String DEFAULT_INDEX_PATH = "/oak:index";
    private boolean shouldPurgeBaseIndex;

    @Override
    public void execute(String ... args) throws Exception {
        Options opts = this.parseCommandLineParams(args);
        try (NodeStoreFixture fixture = NodeStoreFixtureProvider.create(opts);){
            if (!opts.getCommonOpts().isReadWrite()) {
                LOG.info("Repository connected in read-only mode. Use '--read-write' for write operations");
            }
            this.getPurgeOldIndexVersionInstance().execute(fixture.getStore(), opts.getCommonOpts().isReadWrite(), this.threshold, this.indexPaths, this.shouldPurgeBaseIndex);
        }
    }

    private Options parseCommandLineParams(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec thresholdOption = parser.accepts("threshold").withOptionalArg().ofType(Long.class).defaultsTo((Object)this.DEFAULT_PURGE_THRESHOLD, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec indexPathsOption = parser.accepts("index-paths", "Comma separated list of index paths for which the selected operations need to be performed").withOptionalArg().ofType(String.class).withValuesSeparatedBy(",").defaultsTo((Object)DEFAULT_INDEX_PATH, (Object[])new String[0]);
        OptionSpecBuilder donotPurgeBaseIndexOption = parser.accepts("donot-purge-base-index", "Don't disable base index");
        Options opts = new Options();
        OptionSet optionSet = opts.parseAndConfigure(parser, args);
        this.threshold = (Long)optionSet.valueOf((OptionSpec)thresholdOption);
        this.indexPaths = optionSet.valuesOf((OptionSpec)indexPathsOption);
        this.shouldPurgeBaseIndex = !optionSet.has((OptionSpec)donotPurgeBaseIndexOption);
        return opts;
    }

    protected abstract PurgeOldIndexVersion getPurgeOldIndexVersionInstance();
}

