/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.guava.common.io.Files;
import org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.AzureDataStore;
import org.apache.jackrabbit.oak.blob.cloud.s3.S3DataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.OakFileDataStore;
import org.apache.jackrabbit.oak.run.cli.BlobStoreFixture;
import org.apache.jackrabbit.oak.run.cli.BlobStoreOptions;
import org.apache.jackrabbit.oak.run.cli.DummyDataStore;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.run.cli.ReadOnlyBlobStoreWrapper;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.Nullable;

public class BlobStoreFixtureProvider {
    @Nullable
    public static BlobStoreFixture create(Options options) throws Exception {
        OakFileDataStore delegate;
        BlobStoreOptions bsopts = options.getOptionBean(BlobStoreOptions.class);
        if (bsopts == null) {
            return null;
        }
        BlobStoreOptions.Type bsType = bsopts.getBlobStoreType();
        if (bsType == BlobStoreOptions.Type.NONE) {
            return null;
        }
        Closer closer = Closer.create();
        if (bsType == BlobStoreOptions.Type.S3) {
            S3DataStore s3ds = new S3DataStore();
            Properties props = BlobStoreFixtureProvider.loadConfig(bsopts.getS3ConfigPath());
            s3ds.setProperties(props);
            File homeDir = Files.createTempDir();
            closer.register(BlobStoreFixtureProvider.asCloseable(homeDir));
            PropertiesUtil.populate((Object)s3ds, BlobStoreFixtureProvider.asMap(props), (boolean)false);
            s3ds.init(homeDir.getAbsolutePath());
            delegate = s3ds;
        } else if (bsType == BlobStoreOptions.Type.AZURE) {
            AzureDataStore azureds = new AzureDataStore();
            String cfgPath = bsopts.getAzureConfigPath();
            Properties props = BlobStoreFixtureProvider.loadConfig(cfgPath);
            azureds.setProperties(props);
            File homeDir = Files.createTempDir();
            PropertiesUtil.populate((Object)azureds, BlobStoreFixtureProvider.asMap(props), (boolean)false);
            azureds.init(homeDir.getAbsolutePath());
            closer.register(BlobStoreFixtureProvider.asCloseable(homeDir));
            delegate = azureds;
        } else if (bsType == BlobStoreOptions.Type.FAKE) {
            DummyDataStore fakeDs = new DummyDataStore();
            fakeDs.setPath(bsopts.getFakeDataStorePath());
            fakeDs.init(null);
            delegate = fakeDs;
        } else {
            OakFileDataStore fds;
            delegate = fds = new OakFileDataStore();
            if (bsopts.getFDSPath() != null) {
                fds.setPath(bsopts.getFDSPath());
            } else {
                String cfgPath = bsopts.getFDSConfigPath();
                Properties props = BlobStoreFixtureProvider.loadAndTransformProps(cfgPath);
                PropertiesUtil.populate((Object)delegate, BlobStoreFixtureProvider.asMap(props), (boolean)true);
            }
            delegate.init(null);
        }
        DataStoreBlobStore blobStore = new DataStoreBlobStore((DataStore)delegate);
        return new DataStoreFixture(blobStore, closer, !options.getCommonOpts().isReadWrite() && !bsopts.isReadWrite());
    }

    static Properties loadConfig(String cfgPath) throws IOException {
        Properties props;
        String extension = FilenameUtils.getExtension((String)cfgPath);
        if ("config".equals(extension)) {
            props = BlobStoreFixtureProvider.loadAndTransformProps(cfgPath);
        } else {
            props = new Properties();
            try (FileInputStream is = FileUtils.openInputStream((File)new File(cfgPath));){
                props.load(is);
            }
        }
        return props;
    }

    private static Properties loadAndTransformProps(String cfgPath) throws IOException {
        Dictionary dict = ConfigurationHandler.read((InputStream)new FileInputStream(cfgPath));
        Properties props = new Properties();
        Enumeration keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            props.put(key, dict.get(key));
        }
        return props;
    }

    private static Closeable asCloseable(File dir) {
        return () -> FileUtils.deleteDirectory((File)dir);
    }

    private static Map<String, ?> asMap(Properties props) {
        HashMap map = Maps.newHashMap();
        for (Object key : props.keySet()) {
            map.put((String)key, props.get(key));
        }
        return map;
    }

    private static class DataStoreFixture
    implements BlobStoreFixture {
        private final DataStoreBlobStore blobStore;
        private final Closer closer;
        private final boolean readOnly;
        private final BlobStore readOnlyBlobStore;

        private DataStoreFixture(DataStoreBlobStore blobStore, Closer closer, boolean readOnly) {
            this.blobStore = blobStore;
            this.closer = closer;
            this.readOnly = readOnly;
            this.readOnlyBlobStore = readOnly ? ReadOnlyBlobStoreWrapper.wrap((BlobStore)blobStore) : null;
        }

        @Override
        public BlobStore getBlobStore() {
            return this.readOnly ? this.readOnlyBlobStore : this.blobStore;
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
            try {
                this.blobStore.close();
            }
            catch (DataStoreException e) {
                throw new IOException(e);
            }
        }
    }
}

