/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.cli;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.guava.common.util.concurrent.MoreExecutors;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeStore;
import org.apache.jackrabbit.oak.plugins.metric.MetricStatisticsProvider;
import org.apache.jackrabbit.oak.run.cli.BlobStoreFixture;
import org.apache.jackrabbit.oak.run.cli.BlobStoreFixtureProvider;
import org.apache.jackrabbit.oak.run.cli.CommonOptions;
import org.apache.jackrabbit.oak.run.cli.DocumentFixtureProvider;
import org.apache.jackrabbit.oak.run.cli.NodeStoreFixture;
import org.apache.jackrabbit.oak.run.cli.Options;
import org.apache.jackrabbit.oak.run.cli.SegmentFixtureProvider;
import org.apache.jackrabbit.oak.run.cli.SegmentTarFixtureProvider;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;

public class NodeStoreFixtureProvider {
    public static NodeStoreFixture create(Options options) throws Exception {
        return NodeStoreFixtureProvider.create(options, !options.getOptionBean(CommonOptions.class).isReadWrite());
    }

    public static NodeStoreFixture create(Options options, boolean readOnly) throws Exception {
        MemoryNodeStore store;
        CommonOptions commonOpts = options.getOptionBean(CommonOptions.class);
        Closer closer = Closer.create();
        ClosingWhiteboard wb = new ClosingWhiteboard(options.getWhiteboard(), closer);
        BlobStoreFixture blobFixture = BlobStoreFixtureProvider.create(options);
        BlobStore blobStore = null;
        if (blobFixture != null) {
            blobStore = blobFixture.getBlobStore();
            closer.register((Closeable)blobFixture);
        }
        StatisticsProvider statisticsProvider = NodeStoreFixtureProvider.createStatsProvider(options, wb, closer);
        wb.register(StatisticsProvider.class, statisticsProvider, Collections.emptyMap());
        if (commonOpts.isMemory()) {
            store = new MemoryNodeStore();
        } else if (commonOpts.isMongo() || commonOpts.isRDB()) {
            DocumentNodeStore dns = DocumentFixtureProvider.configureDocumentMk(options, blobStore, wb, closer, readOnly);
            store = dns;
            if (blobStore == null) {
                blobStore = dns.getBlobStore();
            }
        } else if (commonOpts.isOldSegment()) {
            store = SegmentFixtureProvider.create(options, blobStore, wb, closer, readOnly);
        } else {
            try {
                store = SegmentTarFixtureProvider.configureSegment(options, blobStore, wb, closer, readOnly);
            }
            catch (InvalidFileStoreVersionException e) {
                if (NodeStoreFixtureProvider.oldSegmentStore(options)) {
                    store = SegmentFixtureProvider.create(options, blobStore, wb, closer, readOnly);
                }
                throw e;
            }
        }
        return new SimpleNodeStoreFixture((NodeStore)store, blobStore, wb, closer);
    }

    private static boolean oldSegmentStore(Options options) {
        String path = options.getOptionBean(CommonOptions.class).getStoreArg();
        File dir = new File(path);
        File manifest = new File(dir, "manifest");
        return !manifest.exists();
    }

    private static StatisticsProvider createStatsProvider(Options options, Whiteboard wb, Closer closer) {
        if (options.getCommonOpts().isMetricsEnabled()) {
            ScheduledExecutorService executorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
            MetricStatisticsProvider statsProvider = new MetricStatisticsProvider(ManagementFactory.getPlatformMBeanServer(), executorService);
            closer.register((Closeable)statsProvider);
            closer.register(() -> NodeStoreFixtureProvider.reportMetrics(statsProvider));
            wb.register(MetricRegistry.class, (Object)statsProvider.getRegistry(), Collections.emptyMap());
            return statsProvider;
        }
        return StatisticsProvider.NOOP;
    }

    private static void reportMetrics(MetricStatisticsProvider statsProvider) {
        MetricRegistry metricRegistry = statsProvider.getRegistry();
        ConsoleReporter.forRegistry((MetricRegistry)metricRegistry).outputTo(System.out).filter((name, metric) -> {
            if (metric instanceof Counting) {
                return ((Counting)metric).getCount() > 0L;
            }
            return true;
        }).build().report();
    }

    private static class ClosingWhiteboard
    implements Whiteboard {
        private final Whiteboard delegate;
        private final Closer closer;

        public ClosingWhiteboard(Whiteboard delegate, Closer closer) {
            this.delegate = delegate;
            this.closer = closer;
        }

        public <T> Registration register(Class<T> type, T service, Map<?, ?> properties) {
            Registration reg = this.delegate.register(type, service, properties);
            this.closer.register(() -> ((Registration)reg).unregister());
            return reg;
        }

        public <T> Tracker<T> track(Class<T> type) {
            return this.delegate.track(type);
        }

        public <T> Tracker<T> track(Class<T> type, Map<String, String> filterProperties) {
            return this.delegate.track(type, filterProperties);
        }
    }

    private static class SimpleNodeStoreFixture
    implements NodeStoreFixture {
        private final Closer closer;
        private final NodeStore nodeStore;
        private final BlobStore blobStore;
        private final Whiteboard whiteboard;

        private SimpleNodeStoreFixture(NodeStore nodeStore, BlobStore blobStore, Whiteboard whiteboard, Closer closer) {
            this.blobStore = blobStore;
            this.whiteboard = whiteboard;
            this.closer = closer;
            this.nodeStore = nodeStore;
        }

        @Override
        public NodeStore getStore() {
            return this.nodeStore;
        }

        @Override
        public BlobStore getBlobStore() {
            return this.blobStore;
        }

        @Override
        public Whiteboard getWhiteboard() {
            return this.whiteboard;
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }
}

