/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run.commons;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInitializer {
    private static final String LOGBACK_XML_PREFIX = "logback-";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File workDir;
    private final String config;
    private final String logIdentifier;
    private final boolean doReset;

    public LoggingInitializer(File workDir, String logIdentifier) {
        this.workDir = workDir;
        this.logIdentifier = logIdentifier;
        this.config = LOGBACK_XML_PREFIX + logIdentifier + ".xml";
        this.doReset = true;
    }

    public LoggingInitializer(File workDir, String logIdentifier, boolean reset) {
        this.workDir = workDir;
        this.logIdentifier = logIdentifier;
        this.config = LOGBACK_XML_PREFIX + logIdentifier + ".xml";
        this.doReset = reset;
    }

    public void init() throws IOException {
        if (System.getProperty("logback.configurationFile") != null) {
            return;
        }
        File config = this.copyDefaultConfig();
        this.configureLogback(config);
        this.log.info("Logging configured from {}", (Object)config.getAbsolutePath());
        this.log.info("Any change in logging config would be picked up");
        this.log.info("Logs would be written to {}", (Object)new File(this.workDir, this.logIdentifier + ".log"));
    }

    public static void shutdownLogging() {
        if (System.getProperty("logback.configurationFile") != null) {
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.stop();
    }

    private void configureLogback(File config) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            System.setProperty("oak.workDir", FilenameUtils.normalizeNoEndSeparator((String)this.workDir.getAbsolutePath()));
            if (this.doReset) {
                context.reset();
            }
            configurator.doConfigure(config);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    private File copyDefaultConfig() throws IOException {
        URL url = this.getClass().getResource("/" + this.config);
        File dest = new File(this.workDir, this.config);
        try (InputStream is = url.openStream();){
            FileUtils.copyInputStreamToFile((InputStream)is, (File)dest);
        }
        return dest;
    }
}

