/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclGroupDeprecation {
    private static final Logger LOG;
    private static final String DEFAULT = "error";
    private static final String TLOGLEVEL;
    private static String LOGLEVEL;

    private AclGroupDeprecation() {
    }

    public static void handleCall() throws UnsupportedOperationException {
        String message = "use of deprecated java.acl.Group-related API - this method is going to be removed in future Oak releases - see OAK-7358 for details";
        switch (LOGLEVEL) {
            case "error": {
                if (!LOG.isErrorEnabled()) break;
                LOG.error(message, (Throwable)new Exception("call stack"));
                break;
            }
            case "warn": {
                if (!LOG.isWarnEnabled()) break;
                LOG.warn(message, (Throwable)new Exception("call stack"));
                break;
            }
            case "info": {
                if (!LOG.isInfoEnabled()) break;
                LOG.info(message, (Throwable)new Exception("call stack"));
                break;
            }
            case "debug": {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug(message, (Throwable)new Exception("call stack"));
            }
        }
    }

    public static String setLogLevel(String level) {
        String before = LOGLEVEL;
        LOGLEVEL = level;
        return before;
    }

    static {
        String t;
        LOG = LoggerFactory.getLogger(AclGroupDeprecation.class);
        TLOGLEVEL = System.getProperty("org.apache.jackrabbit.oak.spi.tools.AclGroupDeprecation.LOGLEVEL", DEFAULT);
        switch (TLOGLEVEL.toLowerCase(Locale.ENGLISH)) {
            case "error": {
                t = TLOGLEVEL.toLowerCase(Locale.ENGLISH);
                break;
            }
            default: {
                t = DEFAULT;
            }
        }
        LOGLEVEL = t;
    }
}

