/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImmutablePrivilegeDefinition
implements PrivilegeDefinition {
    private final String name;
    private final boolean isAbstract;
    private final Set<String> declaredAggregateNames;
    private final int hashcode;

    public ImmutablePrivilegeDefinition(@NotNull String name, boolean isAbstract, @Nullable Iterable<String> declaredAggregateNames) {
        this.name = name;
        this.isAbstract = isAbstract;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (declaredAggregateNames != null) {
            builder.addAll(declaredAggregateNames);
        }
        this.declaredAggregateNames = builder.build();
        this.hashcode = Objects.hashCode((Object[])new Object[]{this.name, this.isAbstract, this.declaredAggregateNames});
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    @NotNull
    public Set<String> getDeclaredAggregateNames() {
        return this.declaredAggregateNames;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutablePrivilegeDefinition) {
            ImmutablePrivilegeDefinition other = (ImmutablePrivilegeDefinition)o;
            return this.name.equals(other.name) && this.isAbstract == other.isAbstract && this.declaredAggregateNames.equals(other.declaredAggregateNames);
        }
        return false;
    }

    public String toString() {
        return "PrivilegeDefinition: " + this.name;
    }
}

