/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.spi.security.authentication.credentials.CredentialsSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleCredentialsSupport
implements CredentialsSupport {
    private static final SimpleCredentialsSupport INSTANCE = new SimpleCredentialsSupport();

    private SimpleCredentialsSupport() {
    }

    public static CredentialsSupport getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Set<Class> getCredentialClasses() {
        return ImmutableSet.of(SimpleCredentials.class);
    }

    @Override
    @Nullable
    public String getUserId(@NotNull Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            return ((SimpleCredentials)credentials).getUserID();
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, ?> getAttributes(@NotNull Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials sc = (SimpleCredentials)credentials;
            return Maps.asMap((Set)ImmutableSet.copyOf((Object[])sc.getAttributeNames()), input -> sc.getAttribute(input));
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean setAttributes(@NotNull Credentials credentials, @NotNull Map<String, ?> attributes) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials sc = (SimpleCredentials)credentials;
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                sc.setAttribute(entry.getKey(), entry.getValue());
            }
            return true;
        }
        return false;
    }
}

