/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.authorization.PrivilegeCollection;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AbstractPrivilegeCollection;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class ACE
implements JackrabbitAccessControlEntry {
    private final Principal principal;
    private final PrivilegeBits privilegeBits;
    private final boolean isAllow;
    private final Set<Restriction> restrictions;
    private final NamePathMapper namePathMapper;
    private final PartialValueFactory valueFactory;
    private int hashCode;

    public ACE(@Nullable Principal principal, @Nullable PrivilegeBits privilegeBits, boolean isAllow, @Nullable Set<Restriction> restrictions, @NotNull NamePathMapper namePathMapper) throws AccessControlException {
        if (principal == null || privilegeBits == null || privilegeBits.isEmpty()) {
            throw new AccessControlException();
        }
        this.principal = principal;
        this.privilegeBits = privilegeBits;
        this.isAllow = isAllow;
        this.restrictions = restrictions == null ? Collections.emptySet() : ImmutableSet.copyOf(restrictions);
        this.namePathMapper = namePathMapper;
        this.valueFactory = new PartialValueFactory(namePathMapper);
    }

    @NotNull
    public PrivilegeBits getPrivilegeBits() {
        return this.privilegeBits;
    }

    @NotNull
    public Set<Restriction> getRestrictions() {
        return this.restrictions;
    }

    @NotNull
    protected abstract PrivilegeBitsProvider getPrivilegeBitsProvider();

    @NotNull
    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isAllow() {
        return this.isAllow;
    }

    @NotNull
    public String[] getRestrictionNames() {
        return (String[])this.restrictions.stream().map(this::getJcrName).toArray(String[]::new);
    }

    @Nullable
    public Value getRestriction(@NotNull String restrictionName) throws RepositoryException {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            if (restriction.getDefinition().getRequiredType().isArray()) {
                List values = this.valueFactory.createValues(restriction.getProperty());
                if (values.size() == 1) {
                    return (Value)values.get(0);
                }
                throw new ValueFormatException("Attempt to retrieve single value from multivalued property");
            }
            return this.valueFactory.createValue(restriction.getProperty());
        }
        return null;
    }

    @Nullable
    public Value[] getRestrictions(@NotNull String restrictionName) {
        for (Restriction restriction : this.restrictions) {
            String jcrName = this.getJcrName(restriction);
            if (!jcrName.equals(restrictionName)) continue;
            List values = this.valueFactory.createValues(restriction.getProperty());
            return values.toArray(new Value[0]);
        }
        return null;
    }

    @NotNull
    public PrivilegeCollection getPrivilegeCollection() {
        return new AbstractPrivilegeCollection(this.privilegeBits){

            public Privilege[] getPrivileges() {
                return ACE.this.getPrivileges();
            }

            @Override
            @NotNull
            PrivilegeBitsProvider getPrivilegeBitsProvider() {
                return ACE.this.getPrivilegeBitsProvider();
            }

            @Override
            @NotNull
            NamePathMapper getNamePathMapper() {
                return ACE.this.namePathMapper;
            }
        };
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.principal.getName(), this.privilegeBits, this.isAllow, this.restrictions);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACE) {
            ACE other = (ACE)obj;
            return this.principal.getName().equals(other.principal.getName()) && this.isAllow == other.isAllow && this.privilegeBits.equals(other.privilegeBits) && this.restrictions.equals(other.restrictions);
        }
        return false;
    }

    private String getJcrName(Restriction restriction) {
        return this.namePathMapper.getJcrName(restriction.getDefinition().getName());
    }
}

