/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.guava.common.collect.FluentIterable;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrivilegeBitsProvider
implements PrivilegeConstants {
    private static final Logger log = LoggerFactory.getLogger(PrivilegeBitsProvider.class);
    private final Map<PrivilegeBits, Set<String>> bitsToNames = new HashMap<PrivilegeBits, Set<String>>();
    private final Map<String, PrivilegeBits> nameToBits = new HashMap<String, PrivilegeBits>();
    private final Map<String, Set<String>> aggregation = new HashMap<String, Set<String>>();
    private final Root root;

    public PrivilegeBitsProvider(Root root) {
        this.root = root;
    }

    @NotNull
    public Tree getPrivilegesTree() {
        return PrivilegeUtil.getPrivilegesTree(this.root);
    }

    @NotNull
    public PrivilegeBits getBits(String ... privilegeNames) {
        if (privilegeNames.length == 0) {
            return PrivilegeBits.EMPTY;
        }
        return this.getBits(Arrays.asList(privilegeNames));
    }

    @NotNull
    public PrivilegeBits getBits(@NotNull Iterable<String> privilegeNames) {
        if (IterableUtils.isEmpty(privilegeNames)) {
            return PrivilegeBits.EMPTY;
        }
        PrivilegeBits bits = PrivilegeBits.getInstance();
        this.collectBits(privilegeNames, bits);
        return bits.unmodifiable();
    }

    @NotNull
    public PrivilegeBits getBits(@NotNull Iterable<String> privilegeNames, boolean validateNames) throws AccessControlException {
        if (!validateNames) {
            return this.getBits(privilegeNames);
        }
        if (IterableUtils.isEmpty(privilegeNames)) {
            return PrivilegeBits.EMPTY;
        }
        PrivilegeBits bits = PrivilegeBits.getInstance();
        if (!this.collectBits(privilegeNames, bits)) {
            throw new AccessControlException("Invalid privilege name contained in " + privilegeNames);
        }
        return bits.unmodifiable();
    }

    private boolean collectBits(@NotNull Iterable<String> privilegeNames, @NotNull PrivilegeBits bits) {
        Tree privilegesTree = null;
        boolean allNamesValid = true;
        for (String privilegeName : privilegeNames) {
            PrivilegeBits builtIn = PrivilegeBits.BUILT_IN.get(privilegeName);
            if (builtIn != null) {
                bits.add(builtIn);
                continue;
            }
            if (this.nameToBits.containsKey(privilegeName)) {
                bits.add(this.nameToBits.get(privilegeName));
                continue;
            }
            if (privilegesTree == null) {
                privilegesTree = this.getPrivilegesTree();
            }
            if (privilegesTree.exists() && privilegesTree.hasChild(privilegeName)) {
                Tree defTree = privilegesTree.getChild(privilegeName);
                PrivilegeBits bitsFromDefTree = PrivilegeBits.getInstance(defTree);
                this.nameToBits.put(privilegeName, bitsFromDefTree);
                bits.add(bitsFromDefTree);
                continue;
            }
            log.debug("Invalid privilege name {}", (Object)privilegeName);
            allNamesValid = false;
        }
        return allNamesValid;
    }

    @NotNull
    public PrivilegeBits getBits(@NotNull Privilege[] privileges, @NotNull NameMapper nameMapper) {
        return this.getBits(IterableUtils.filter((Iterable)IterableUtils.transform(Arrays.asList(privileges), privilege -> nameMapper.getOakNameOrNull(privilege.getName())), x -> x != null));
    }

    @NotNull
    public Set<String> getPrivilegeNames(@Nullable PrivilegeBits privilegeBits) {
        Set<String> privilegeNames;
        if (privilegeBits == null || privilegeBits.isEmpty()) {
            return Collections.emptySet();
        }
        PrivilegeBits pb = privilegeBits.unmodifiable();
        if (this.bitsToNames.containsKey(pb)) {
            return this.bitsToNames.get(pb);
        }
        Tree privilegesTree = this.getPrivilegesTree();
        if (!privilegesTree.exists()) {
            return Collections.emptySet();
        }
        if (this.bitsToNames.isEmpty()) {
            for (Tree child : privilegesTree.getChildren()) {
                this.bitsToNames.put(PrivilegeBits.getInstance(child), Collections.singleton(child.getName()));
            }
        }
        if (this.bitsToNames.containsKey(pb)) {
            privilegeNames = this.bitsToNames.get(pb);
        } else {
            privilegeNames = PrivilegeBitsProvider.collectPrivilegeNames(privilegesTree, pb);
            this.bitsToNames.put(pb, Collections.unmodifiableSet(SetUtils.toLinkedSet(privilegeNames)));
        }
        return privilegeNames;
    }

    @NotNull
    private static Set<String> collectPrivilegeNames(@NotNull Tree privilegesTree, @NotNull PrivilegeBits pb) {
        HashSet<String> privilegeNames = new HashSet<String>();
        HashSet<String> aggregates = new HashSet<String>();
        for (Tree child : privilegesTree.getChildren()) {
            PrivilegeBits bits = PrivilegeBits.getInstance(child);
            if (!pb.includes(bits)) continue;
            privilegeNames.add(child.getName());
            if (!child.hasProperty("rep:aggregates")) continue;
            aggregates.addAll(PrivilegeUtil.readDefinition(child).getDeclaredAggregateNames());
        }
        privilegeNames.removeAll(aggregates);
        return privilegeNames;
    }

    @NotNull
    public Iterable<String> getAggregatedPrivilegeNames(String ... privilegeNames) {
        if (privilegeNames.length == 0) {
            return Collections.emptySet();
        }
        if (privilegeNames.length == 1) {
            String privName = privilegeNames[0];
            if (NON_AGGREGATE_PRIVILEGES.contains(privName)) {
                return Set.of(privName);
            }
            if (this.aggregation.containsKey(privName)) {
                return this.aggregation.get(privName);
            }
            if (AGGREGATE_PRIVILEGES.containsKey(privName)) {
                Set<String> aggregates = this.resolveBuiltInAggregation(privName);
                this.aggregation.put(privName, aggregates);
                return aggregates;
            }
            return this.extractAggregatedPrivileges(Collections.singleton(privName));
        }
        Set<String> pNames = Collections.unmodifiableSet(SetUtils.toLinkedSet((Object[])privilegeNames));
        if (NON_AGGREGATE_PRIVILEGES.containsAll(pNames)) {
            return pNames;
        }
        return this.extractAggregatedPrivileges(pNames);
    }

    @NotNull
    private Iterable<String> extractAggregatedPrivileges(@NotNull Iterable<String> privilegeNames) {
        return FluentIterable.from(privilegeNames).transformAndConcat(new ExtractAggregatedPrivileges()::apply);
    }

    @NotNull
    private Set<String> resolveBuiltInAggregation(@NotNull String privilegeName) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String name : (String[])AGGREGATE_PRIVILEGES.get(privilegeName)) {
            if (!AGGREGATE_PRIVILEGES.containsKey(name)) {
                builder.add((Object)name);
                continue;
            }
            builder.addAll(this.resolveBuiltInAggregation(name));
        }
        ImmutableSet set = builder.build();
        this.aggregation.put(privilegeName, (Set<String>)set);
        return set;
    }

    private final class ExtractAggregatedPrivileges
    implements Function<String, Iterable<String>> {
        private ExtractAggregatedPrivileges() {
        }

        @Override
        @NotNull
        public Iterable<String> apply(@Nullable String privName) {
            if (privName == null) {
                return Collections.emptySet();
            }
            if (PrivilegeConstants.NON_AGGREGATE_PRIVILEGES.contains(privName)) {
                return Collections.singleton(privName);
            }
            if (PrivilegeBitsProvider.this.aggregation.containsKey(privName)) {
                return PrivilegeBitsProvider.this.aggregation.get(privName);
            }
            if (PrivilegeConstants.AGGREGATE_PRIVILEGES.containsKey(privName)) {
                return PrivilegeBitsProvider.this.resolveBuiltInAggregation(privName);
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            this.fillAggregation(PrivilegeBitsProvider.this.getPrivilegesTree().getChild(privName), (ImmutableSet.Builder<String>)builder);
            ImmutableSet aggregates = builder.build();
            if (!"jcr:all".equals(privName) && !aggregates.isEmpty()) {
                PrivilegeBitsProvider.this.aggregation.put(privName, (Set<String>)aggregates);
            }
            return aggregates;
        }

        private void fillAggregation(@NotNull Tree privTree, @NotNull ImmutableSet.Builder<String> builder) {
            if (!privTree.exists()) {
                return;
            }
            PropertyState aggregates = privTree.getProperty("rep:aggregates");
            if (aggregates != null) {
                for (String name : (Iterable)aggregates.getValue(Type.NAMES)) {
                    if (PrivilegeConstants.NON_AGGREGATE_PRIVILEGES.contains(name)) {
                        builder.add((Object)name);
                        continue;
                    }
                    if (PrivilegeBitsProvider.this.aggregation.containsKey(name)) {
                        builder.addAll((Iterable)PrivilegeBitsProvider.this.aggregation.get(name));
                        continue;
                    }
                    if (PrivilegeConstants.AGGREGATE_PRIVILEGES.containsKey(name)) {
                        builder.addAll(PrivilegeBitsProvider.this.resolveBuiltInAggregation(name));
                        continue;
                    }
                    this.fillAggregation(privTree.getParent().getChild(name), builder);
                }
            } else {
                builder.add((Object)privTree.getName());
            }
        }
    }
}

