/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authorization.permission;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public interface TreePermission {
    public static final TreePermission EMPTY = new TreePermission(){

        @Override
        @Nonnull
        public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
            return EMPTY;
        }

        @Override
        public boolean canRead() {
            return false;
        }

        @Override
        public boolean canRead(@Nonnull PropertyState property) {
            return false;
        }

        @Override
        public boolean canReadAll() {
            return false;
        }

        @Override
        public boolean canReadProperties() {
            return false;
        }

        @Override
        public boolean isGranted(long permissions) {
            return false;
        }

        @Override
        public boolean isGranted(long permissions, @Nonnull PropertyState property) {
            return false;
        }

        public String toString() {
            return "TreePermission.EMPTY";
        }
    };
    public static final TreePermission ALL = new TreePermission(){

        @Override
        @Nonnull
        public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
            return ALL;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canRead(@Nonnull PropertyState property) {
            return true;
        }

        @Override
        public boolean canReadAll() {
            return true;
        }

        @Override
        public boolean canReadProperties() {
            return true;
        }

        @Override
        public boolean isGranted(long permissions) {
            return true;
        }

        @Override
        public boolean isGranted(long permissions, @Nonnull PropertyState property) {
            return true;
        }

        public String toString() {
            return "TreePermission.ALL";
        }
    };
    public static final TreePermission NO_RECOURSE = new TreePermission(){

        @Override
        @Nonnull
        public TreePermission getChildPermission(@Nonnull String childName, @Nonnull NodeState childState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canRead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canRead(@Nonnull PropertyState property) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canReadAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canReadProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGranted(long permissions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isGranted(long permissions, @Nonnull PropertyState property) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "TreePermission.NO_RECOURSE";
        }
    };

    @Nonnull
    public TreePermission getChildPermission(@Nonnull String var1, @Nonnull NodeState var2);

    public boolean canRead();

    public boolean canRead(@Nonnull PropertyState var1);

    public boolean canReadAll();

    public boolean canReadProperties();

    public boolean isGranted(long var1);

    public boolean isGranted(long var1, @Nonnull PropertyState var3);
}

