/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import com.google.common.base.Objects;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuthInfoImpl
implements AuthInfo {
    private final String userID;
    private final Map<String, ?> attributes;
    private final Set<Principal> principals;

    public AuthInfoImpl(@Nullable String userID, @Nullable Map<String, ?> attributes, @Nullable Set<? extends Principal> principals) {
        this.userID = userID;
        this.attributes = attributes == null ? Collections.emptyMap() : attributes;
        this.principals = principals == null ? Collections.emptySet() : Collections.unmodifiableSet(principals);
    }

    public static AuthInfo createFromSubject(@NotNull Subject subject) {
        Set<AuthInfo> infoSet = subject.getPublicCredentials(AuthInfo.class);
        if (infoSet.isEmpty()) {
            Set<SimpleCredentials> scs = subject.getPublicCredentials(SimpleCredentials.class);
            String userId = scs.isEmpty() ? null : scs.iterator().next().getUserID();
            return new AuthInfoImpl(userId, null, subject.getPrincipals());
        }
        return infoSet.iterator().next();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("userID", (Object)this.userID).add("attributes", this.attributes).add("principals", this.principals).toString();
    }

    public String getUserID() {
        return this.userID;
    }

    @NotNull
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Object getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @NotNull
    public Set<Principal> getPrincipals() {
        return this.principals;
    }
}

