/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.credentials;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCredentials
implements Credentials {
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final String userId;

    public AbstractCredentials(@NotNull String userId) {
        this.userId = userId;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object getAttribute(@NotNull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(@NotNull String name) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.remove(name);
        }
    }

    @NotNull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(@NotNull Map<String, Object> attributes) {
        Map<String, Object> map = attributes;
        synchronized (map) {
            this.attributes.putAll(attributes);
        }
    }
}

