/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.principal.EmptyPrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositePrincipalProvider
implements PrincipalProvider {
    private final List<PrincipalProvider> providers;

    public CompositePrincipalProvider(List<PrincipalProvider> providers) {
        this.providers = (List)Preconditions.checkNotNull(providers);
    }

    public static PrincipalProvider of(@NotNull List<PrincipalProvider> providers) {
        PrincipalProvider pp;
        switch (providers.size()) {
            case 0: {
                pp = EmptyPrincipalProvider.INSTANCE;
                break;
            }
            case 1: {
                pp = providers.get(0);
                break;
            }
            default: {
                pp = new CompositePrincipalProvider(providers);
            }
        }
        return pp;
    }

    @Override
    public Principal getPrincipal(@NotNull String principalName) {
        Principal principal = null;
        for (int i = 0; i < this.providers.size() && principal == null; ++i) {
            principal = this.providers.get(i).getPrincipal(principalName);
        }
        return principal;
    }

    @Override
    @NotNull
    public Set<Group> getGroupMembership(@NotNull Principal principal) {
        HashSet<Group> groups = new HashSet<Group>();
        for (PrincipalProvider provider : this.providers) {
            groups.addAll(provider.getGroupMembership(principal));
        }
        return groups;
    }

    @NotNull
    public Set<Principal> getPrincipals(@NotNull String userID) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (PrincipalProvider provider : this.providers) {
            principals.addAll(provider.getPrincipals(userID));
        }
        return principals;
    }

    @NotNull
    public Iterator<Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        Iterator[] iterators = new Iterator[this.providers.size()];
        int i = 0;
        for (PrincipalProvider provider : this.providers) {
            if (nameHint == null) {
                iterators[i++] = provider.findPrincipals(searchType);
                continue;
            }
            iterators[i++] = provider.findPrincipals(nameHint, searchType);
        }
        return Iterators.concat((Iterator[])iterators);
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }
}

