/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import java.security.Principal;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrincipalManagerImpl
implements PrincipalManager {
    private final PrincipalProvider principalProvider;

    public PrincipalManagerImpl(@NotNull PrincipalProvider principalProvider) {
        this.principalProvider = principalProvider;
    }

    public boolean hasPrincipal(@NotNull String principalName) {
        return this.principalProvider.getPrincipal(principalName) != null;
    }

    @Nullable
    public Principal getPrincipal(@NotNull String principalName) {
        return this.principalProvider.getPrincipal(principalName);
    }

    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter, int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(simpleFilter, searchType));
    }

    @NotNull
    public PrincipalIterator getPrincipals(int searchType) {
        return new PrincipalIteratorAdapter(this.principalProvider.findPrincipals(searchType));
    }

    @NotNull
    public PrincipalIterator getGroupMembership(@NotNull Principal principal) {
        return new PrincipalIteratorAdapter(this.principalProvider.getGroupMembership(principal));
    }

    @NotNull
    public Principal getEveryone() {
        Object everyone = this.getPrincipal("everyone");
        if (everyone == null) {
            everyone = EveryonePrincipal.getInstance();
        }
        return everyone;
    }
}

