/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.token;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;

public class CompositeTokenConfiguration
extends CompositeConfiguration<TokenConfiguration>
implements TokenConfiguration {
    public CompositeTokenConfiguration() {
        super("org.apache.jackrabbit.oak.authentication.token");
    }

    public CompositeTokenConfiguration(@NotNull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.authentication.token", securityProvider);
    }

    @Override
    @NotNull
    public TokenProvider getTokenProvider(final Root root) {
        List providers = Lists.transform(this.getConfigurations(), (Function)new Function<TokenConfiguration, TokenProvider>(){

            public TokenProvider apply(TokenConfiguration tokenConfiguration) {
                return tokenConfiguration.getTokenProvider(root);
            }
        });
        return CompositeTokenProvider.newInstance(providers);
    }
}

