/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.jetbrains.annotations.NotNull;

public class CompositeActionProvider
implements AuthorizableActionProvider {
    private final Collection<? extends AuthorizableActionProvider> providers;

    public CompositeActionProvider(Collection<? extends AuthorizableActionProvider> providers) {
        this.providers = providers;
    }

    public CompositeActionProvider(AuthorizableActionProvider ... providers) {
        this.providers = Arrays.asList(providers);
    }

    @Override
    @NotNull
    public List<? extends AuthorizableAction> getAuthorizableActions(@NotNull SecurityProvider securityProvider) {
        ArrayList actions = Lists.newArrayList();
        for (AuthorizableActionProvider authorizableActionProvider : this.providers) {
            actions.addAll(authorizableActionProvider.getAuthorizableActions(securityProvider));
        }
        return actions;
    }
}

