/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.azure.AzureSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.azure.util.CaseInsensitiveKeysMapAccess;

public final class AzureBlobMetadata {
    static final String METADATA_TYPE = "type";
    static final String METADATA_SEGMENT_UUID = "uuid";
    static final String METADATA_SEGMENT_POSITION = "position";
    static final String METADATA_SEGMENT_GENERATION = "generation";
    static final String METADATA_SEGMENT_FULL_GENERATION = "fullGeneration";
    static final String METADATA_SEGMENT_COMPACTED = "compacted";
    static final String TYPE_SEGMENT = "segment";

    public static HashMap<String, String> toSegmentMetadata(AzureSegmentArchiveEntry indexEntry) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(METADATA_TYPE, TYPE_SEGMENT);
        map.put(METADATA_SEGMENT_UUID, new UUID(indexEntry.getMsb(), indexEntry.getLsb()).toString());
        map.put(METADATA_SEGMENT_POSITION, String.valueOf(indexEntry.getPosition()));
        map.put(METADATA_SEGMENT_GENERATION, String.valueOf(indexEntry.getGeneration()));
        map.put(METADATA_SEGMENT_FULL_GENERATION, String.valueOf(indexEntry.getFullGeneration()));
        map.put(METADATA_SEGMENT_COMPACTED, String.valueOf(indexEntry.isCompacted()));
        return map;
    }

    public static AzureSegmentArchiveEntry toIndexEntry(Map<String, String> metadata, int length) {
        Map<String, String> caseInsensitiveMetadata = CaseInsensitiveKeysMapAccess.convert(metadata);
        UUID uuid = UUID.fromString(caseInsensitiveMetadata.get(METADATA_SEGMENT_UUID));
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int position = Integer.parseInt(caseInsensitiveMetadata.get(METADATA_SEGMENT_POSITION));
        int generation = Integer.parseInt(caseInsensitiveMetadata.get(METADATA_SEGMENT_GENERATION));
        int fullGeneration = Integer.parseInt(caseInsensitiveMetadata.get(METADATA_SEGMENT_FULL_GENERATION));
        boolean compacted = Boolean.parseBoolean(caseInsensitiveMetadata.get(METADATA_SEGMENT_COMPACTED));
        return new AzureSegmentArchiveEntry(msb, lsb, position, length, generation, fullGeneration, compacted);
    }

    public static boolean isSegment(Map<String, String> metadata) {
        Map<String, String> caseInsensitiveMetadata = CaseInsensitiveKeysMapAccess.convert(metadata);
        return metadata != null && TYPE_SEGMENT.equals(caseInsensitiveMetadata.get(METADATA_TYPE));
    }
}

