/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureManifestFile
implements ManifestFile {
    private static final Logger log = LoggerFactory.getLogger(AzureManifestFile.class);
    private final CloudBlockBlob manifestBlob;

    public AzureManifestFile(CloudBlockBlob manifestBlob) {
        this.manifestBlob = manifestBlob;
    }

    public boolean exists() {
        try {
            return this.manifestBlob.exists();
        }
        catch (StorageException e) {
            log.error("Can't check if the manifest exists", (Throwable)e);
            return false;
        }
    }

    public Properties load() throws IOException {
        Properties properties = new Properties();
        if (this.exists()) {
            long length = this.manifestBlob.getProperties().getLength();
            byte[] data = new byte[(int)length];
            try {
                this.manifestBlob.downloadToByteArray(data, 0);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
            properties.load(new ByteArrayInputStream(data));
        }
        return properties;
    }

    public void save(Properties properties) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        properties.store(bos, null);
        byte[] data = bos.toByteArray();
        try {
            this.manifestBlob.uploadFromByteArray(data, 0, data.length);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }
}

