/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.jackrabbit.oak.segment.azure.AzurePersistence;
import org.apache.jackrabbit.oak.segment.azure.Configuration;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService"})
public class AzureSegmentStoreService {
    private static final Logger log = LoggerFactory.getLogger(AzureSegmentStoreService.class);
    public static final String DEFAULT_CONTAINER_NAME = "oak";
    public static final String DEFAULT_ROOT_PATH = "/oak";
    private ServiceRegistration registration;
    private SegmentNodeStorePersistence persistence;

    @Activate
    public void activate(ComponentContext context, Configuration config) throws IOException {
        this.persistence = AzureSegmentStoreService.createAzurePersistence(config);
        this.registration = context.getBundleContext().registerService(SegmentNodeStorePersistence.class.getName(), (Object)this.persistence, (Dictionary)new Properties());
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.persistence = null;
    }

    private static SegmentNodeStorePersistence createAzurePersistence(Configuration configuration) throws IOException {
        try {
            StringBuilder connectionString = new StringBuilder();
            if (configuration.connectionURL() == null || configuration.connectionURL().trim().isEmpty()) {
                connectionString.append("DefaultEndpointsProtocol=https;");
                connectionString.append("AccountName=").append(configuration.accountName()).append(';');
                connectionString.append("AccountKey=").append(configuration.accessKey()).append(';');
            } else {
                connectionString.append(configuration.connectionURL());
            }
            log.info("Connection string: '{}'", (Object)connectionString.toString());
            CloudStorageAccount cloud = CloudStorageAccount.parse(connectionString.toString());
            CloudBlobContainer container = cloud.createCloudBlobClient().getContainerReference(configuration.containerName());
            container.createIfNotExists();
            String path = configuration.rootPath();
            if (path != null && path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            AzurePersistence persistence = new AzurePersistence(container.getDirectoryReference(path));
            return persistence;
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            throw new IOException(e);
        }
    }
}

