/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(pid={"org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService"}, name="Apache Jackrabbit Oak Azure Segment Store Service", description="Azure backend for the Oak Segment Node Store")
@interface Configuration {
    public static final String PID = "org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService";

    @AttributeDefinition(name="Azure account name", description="Name of the Azure Storage account to use.")
    public String accountName();

    @AttributeDefinition(name="Azure container name", description="Name of the container to use. If it doesn't exists, it'll be created.")
    public String containerName() default "oak";

    @AttributeDefinition(name="Azure account access key", description="Access key which should be used to authenticate on the account")
    public String accessKey();

    @AttributeDefinition(name="Root path", description="Names of all the created blobs will be prefixed with this path")
    public String rootPath() default "/oak";

    @AttributeDefinition(name="Azure connection string (optional)", description="Connection string to be used to connect to the Azure Storage. Setting it will override the accountName and accessKey properties.")
    public String connectionURL() default "";
}

