/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.queue;

import java.io.IOException;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.AzureSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.azure.queue.SegmentWriteQueue;

public class SegmentWriteAction {
    private final AzureSegmentArchiveEntry indexEntry;
    private final byte[] buffer;
    private final int offset;
    private final int length;

    public SegmentWriteAction(AzureSegmentArchiveEntry indexEntry, byte[] buffer, int offset, int length) {
        this.indexEntry = indexEntry;
        this.buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.buffer[i] = buffer[i + offset];
        }
        this.offset = 0;
        this.length = length;
    }

    public UUID getUuid() {
        return new UUID(this.indexEntry.getMsb(), this.indexEntry.getLsb());
    }

    public Buffer toBuffer() {
        return Buffer.wrap((byte[])this.buffer, (int)this.offset, (int)this.length);
    }

    void passTo(SegmentWriteQueue.SegmentConsumer consumer) throws IOException {
        consumer.consume(this.indexEntry, this.buffer, this.offset, this.length);
    }

    public String toString() {
        return this.getUuid().toString();
    }
}

