/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestCompletedEvent;
import com.microsoft.azure.storage.RetryLinearRetry;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.azure.AzureArchiveManager;
import org.apache.jackrabbit.oak.segment.azure.AzureGCJournalFile;
import org.apache.jackrabbit.oak.segment.azure.AzureJournalFile;
import org.apache.jackrabbit.oak.segment.azure.AzureManifestFile;
import org.apache.jackrabbit.oak.segment.azure.AzureRepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzurePersistence
implements SegmentNodeStorePersistence {
    private static int RETRY_ATTEMPTS = Integer.getInteger("segment.azure.retry.attempts", 5);
    private static int RETRY_BACKOFF_SECONDS = Integer.getInteger("segment.azure.retry.backoff", 5);
    private static int TIMEOUT_EXECUTION = Integer.getInteger("segment.timeout.execution", 30);
    private static int TIMEOUT_INTERVAL = Integer.getInteger("segment.timeout.interval", 1);
    private static final Logger log = LoggerFactory.getLogger(AzurePersistence.class);
    protected final CloudBlobDirectory segmentstoreDirectory;

    public AzurePersistence(CloudBlobDirectory segmentStoreDirectory) {
        this.segmentstoreDirectory = segmentStoreDirectory;
        BlobRequestOptions defaultRequestOptions = segmentStoreDirectory.getServiceClient().getDefaultRequestOptions();
        if (defaultRequestOptions.getRetryPolicyFactory() == null && RETRY_ATTEMPTS > 0) {
            defaultRequestOptions.setRetryPolicyFactory(new RetryLinearRetry((int)TimeUnit.SECONDS.toMillis(RETRY_BACKOFF_SECONDS), RETRY_ATTEMPTS));
        }
        if (defaultRequestOptions.getMaximumExecutionTimeInMs() == null && TIMEOUT_EXECUTION > 0) {
            defaultRequestOptions.setMaximumExecutionTimeInMs((int)TimeUnit.SECONDS.toMillis(TIMEOUT_EXECUTION));
        }
        if (defaultRequestOptions.getTimeoutIntervalInMs() == null && TIMEOUT_INTERVAL > 0) {
            defaultRequestOptions.setTimeoutIntervalInMs((int)TimeUnit.SECONDS.toMillis(TIMEOUT_INTERVAL));
        }
    }

    public SegmentArchiveManager createArchiveManager(boolean mmap, boolean offHeapAccess, IOMonitor ioMonitor, FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) {
        AzurePersistence.attachRemoteStoreMonitor(remoteStoreMonitor);
        return new AzureArchiveManager(this.segmentstoreDirectory, ioMonitor, fileStoreMonitor);
    }

    public boolean segmentFilesExist() {
        try {
            for (ListBlobItem i : this.segmentstoreDirectory.listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), null, null)) {
                CloudBlobDirectory dir;
                String name;
                if (!(i instanceof CloudBlobDirectory) || !(name = Paths.get((dir = (CloudBlobDirectory)i).getPrefix(), new String[0]).getFileName().toString()).endsWith(".tar")) continue;
                return true;
            }
            return false;
        }
        catch (StorageException | URISyntaxException e) {
            log.error("Can't check if the segment archives exists", (Throwable)e);
            return false;
        }
    }

    public JournalFile getJournalFile() {
        return new AzureJournalFile(this.segmentstoreDirectory, "journal.log");
    }

    public GCJournalFile getGCJournalFile() throws IOException {
        return new AzureGCJournalFile(this.getAppendBlob("gc.log"));
    }

    public ManifestFile getManifestFile() throws IOException {
        return new AzureManifestFile(this.getBlockBlob("manifest"));
    }

    public RepositoryLock lockRepository() throws IOException {
        return new AzureRepositoryLock(this.getBlockBlob("repo.lock"), () -> log.warn("Lost connection to the Azure. The client will be closed.")).lock();
    }

    private CloudBlockBlob getBlockBlob(String path) throws IOException {
        try {
            return this.segmentstoreDirectory.getBlockBlobReference(path);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private CloudAppendBlob getAppendBlob(String path) throws IOException {
        try {
            return this.segmentstoreDirectory.getAppendBlobReference(path);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static void attachRemoteStoreMonitor(final RemoteStoreMonitor remoteStoreMonitor) {
        OperationContext.getGlobalRequestCompletedEventHandler().addListener(new StorageEvent<RequestCompletedEvent>(){

            @Override
            public void eventOccurred(RequestCompletedEvent e) {
                Exception exception;
                Date startDate = e.getRequestResult().getStartDate();
                Date stopDate = e.getRequestResult().getStopDate();
                if (startDate != null && stopDate != null) {
                    long requestDuration = stopDate.getTime() - startDate.getTime();
                    remoteStoreMonitor.requestDuration(requestDuration, TimeUnit.MILLISECONDS);
                }
                if ((exception = e.getRequestResult().getException()) == null) {
                    remoteStoreMonitor.requestCount();
                } else {
                    remoteStoreMonitor.requestError();
                }
            }
        });
    }

    public CloudBlobDirectory getSegmentstoreDirectory() {
        return this.segmentstoreDirectory;
    }
}

