/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.segment.azure.tool.ToolUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class AzureCompact {
    private final String path;
    private final int segmentCacheSize;
    private final boolean strictVersionCheck;
    private final long gcLogInterval;
    private final SegmentGCOptions.CompactorType compactorType;

    public static Builder builder() {
        return new Builder();
    }

    private AzureCompact(Builder builder) {
        this.path = builder.path;
        this.segmentCacheSize = builder.segmentCacheSize;
        this.strictVersionCheck = !builder.force;
        this.gcLogInterval = builder.gcLogInterval;
        this.compactorType = builder.compactorType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run() {
        Stopwatch watch = Stopwatch.createStarted();
        SegmentNodeStorePersistence persistence = ToolUtils.newSegmentNodeStorePersistence(ToolUtils.SegmentStoreType.AZURE, this.path);
        SegmentArchiveManager archiveManager = ToolUtils.createArchiveManager(persistence);
        System.out.printf("Compacting %s\n", this.path);
        System.out.printf("    before\n", new Object[0]);
        List beforeArchives = Collections.emptyList();
        try {
            beforeArchives = archiveManager.listArchives();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        AzureCompact.printArchives(System.out, beforeArchives);
        System.out.printf("    -> compacting\n", new Object[0]);
        try (FileStore store = ToolUtils.newFileStore(persistence, Files.createTempDir(), this.strictVersionCheck, this.segmentCacheSize, this.gcLogInterval, this.compactorType);){
            String head;
            if (!store.compactFull()) {
                System.out.printf("Compaction cancelled after %s.\n", ToolUtils.printableStopwatch(watch));
                int n = 1;
                return n;
            }
            System.out.printf("    -> cleaning up\n", new Object[0]);
            store.cleanup();
            JournalFile journal = persistence.getJournalFile();
            try (JournalReader journalReader = new JournalReader(journal);){
                head = String.format("%s root %s\n", ((JournalEntry)journalReader.next()).getRevision(), System.currentTimeMillis());
            }
            var10_17 = null;
            try (JournalFileWriter journalWriter = journal.openJournalWriter();){
                System.out.printf("    -> writing new %s: %s\n", journal.getName(), head);
                journalWriter.truncate();
                journalWriter.writeLine(head);
            }
            catch (Throwable throwable) {
                var10_17 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            watch.stop();
            e.printStackTrace(System.err);
            System.out.printf("Compaction failed after %s.\n", ToolUtils.printableStopwatch(watch));
            return 1;
        }
        watch.stop();
        System.out.printf("    after\n", new Object[0]);
        List afterArchives = Collections.emptyList();
        try {
            afterArchives = archiveManager.listArchives();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        AzureCompact.printArchives(System.out, afterArchives);
        System.out.printf("Compaction succeeded in %s.\n", ToolUtils.printableStopwatch(watch));
        return 0;
    }

    private static void printArchives(PrintStream s, List<String> archives) {
        for (String a : archives) {
            s.printf("        %s\n", a);
        }
    }

    public static class Builder {
        private String path;
        private boolean force;
        private long gcLogInterval = 150000L;
        private int segmentCacheSize = 256;
        private SegmentGCOptions.CompactorType compactorType = SegmentGCOptions.CompactorType.CHECKPOINT_COMPACTOR;

        private Builder() {
        }

        public Builder withPath(String path) {
            this.path = (String)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withForce(boolean force) {
            this.force = force;
            return this;
        }

        public Builder withSegmentCacheSize(int segmentCacheSize) {
            Preconditions.checkArgument((segmentCacheSize > 0 ? 1 : 0) != 0, (Object)"segmentCacheSize must be strictly positive");
            this.segmentCacheSize = segmentCacheSize;
            return this;
        }

        public Builder withGCLogInterval(long gcLogInterval) {
            this.gcLogInterval = gcLogInterval;
            return this;
        }

        public Builder withCompactorType(SegmentGCOptions.CompactorType compactorType) {
            this.compactorType = compactorType;
            return this;
        }

        public AzureCompact build() {
            Preconditions.checkNotNull((Object)this.path);
            return new AzureCompact(this);
        }
    }
}

