/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.io.PrintWriter;
import org.apache.jackrabbit.oak.segment.azure.tool.SegmentStoreMigrator;
import org.apache.jackrabbit.oak.segment.azure.tool.ToolUtils;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;

public class SegmentCopy {
    private final String source;
    private final String destination;
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final Integer revisionCount;
    private SegmentNodeStorePersistence srcPersistence;
    private SegmentNodeStorePersistence destPersistence;

    public static Builder builder() {
        return new Builder();
    }

    public SegmentCopy(Builder builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.srcPersistence = builder.srcPersistence;
        this.destPersistence = builder.destPersistence;
        this.revisionCount = builder.revisionsCount;
        this.outWriter = builder.outWriter;
        this.errWriter = builder.errWriter;
    }

    public int run() {
        Stopwatch watch = Stopwatch.createStarted();
        ToolUtils.SegmentStoreType srcType = ToolUtils.storeTypeFromPathOrUri(this.source);
        ToolUtils.SegmentStoreType destType = ToolUtils.storeTypeFromPathOrUri(this.destination);
        String srcDescription = ToolUtils.storeDescription(srcType, this.source);
        String destDescription = ToolUtils.storeDescription(destType, this.destination);
        try {
            if (this.srcPersistence == null || this.destPersistence == null) {
                this.srcPersistence = ToolUtils.newSegmentNodeStorePersistence(srcType, this.source);
                this.destPersistence = ToolUtils.newSegmentNodeStorePersistence(destType, this.destination);
            }
            ToolUtils.printMessage(this.outWriter, "Started segment-copy transfer!", new Object[0]);
            ToolUtils.printMessage(this.outWriter, "Source: {0}", srcDescription);
            ToolUtils.printMessage(this.outWriter, "Destination: {0}", destDescription);
            SegmentStoreMigrator migrator = new SegmentStoreMigrator.Builder().withSourcePersistence(this.srcPersistence, srcDescription).withTargetPersistence(this.destPersistence, destDescription).withRevisionCount(this.revisionCount).build();
            migrator.migrate();
        }
        catch (Exception e) {
            watch.stop();
            ToolUtils.printMessage(this.errWriter, "A problem occured while copying archives from {0} to {1} ", this.source, this.destination);
            e.printStackTrace(this.errWriter);
            return 1;
        }
        watch.stop();
        ToolUtils.printMessage(this.outWriter, "Segment-copy succeeded in {0}", ToolUtils.printableStopwatch(watch));
        return 0;
    }

    public static class Builder {
        private String source;
        private String destination;
        private SegmentNodeStorePersistence srcPersistence;
        private SegmentNodeStorePersistence destPersistence;
        private PrintWriter outWriter;
        private PrintWriter errWriter;
        private Integer revisionsCount = Integer.MAX_VALUE;

        private Builder() {
        }

        public Builder withSource(String source) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withDestination(String destination) {
            this.destination = (String)Preconditions.checkNotNull((Object)destination);
            return this;
        }

        public Builder withSrcPersistencee(SegmentNodeStorePersistence srcPersistence) {
            this.srcPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)srcPersistence);
            return this;
        }

        public Builder withDestPersistence(SegmentNodeStorePersistence destPersistence) {
            this.destPersistence = (SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)destPersistence);
            return this;
        }

        public Builder withOutWriter(PrintWriter outWriter) {
            this.outWriter = outWriter;
            return this;
        }

        public Builder withErrWriter(PrintWriter errWriter) {
            this.errWriter = errWriter;
            return this;
        }

        public Builder withRevisionsCount(Integer revisionsCount) {
            this.revisionsCount = revisionsCount;
            return this;
        }

        public SegmentCopy build() {
            if (this.srcPersistence == null && this.destPersistence == null) {
                Preconditions.checkNotNull((Object)this.source);
                Preconditions.checkNotNull((Object)this.destination);
            }
            return new SegmentCopy(this);
        }
    }
}

