/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.AzureBlobMetadata;
import org.apache.jackrabbit.oak.segment.azure.AzureUtilities;
import org.apache.jackrabbit.oak.segment.azure.util.Retrier;
import org.apache.jackrabbit.oak.segment.remote.AbstractRemoteSegmentArchiveWriter;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.remote.WriteAccessController;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;

public class AzureSegmentArchiveWriter
extends AbstractRemoteSegmentArchiveWriter {
    private final CloudBlobDirectory archiveDirectory;
    private final Retrier retrier = Retrier.withParams(Integer.getInteger("azure.segment.archive.writer.retries.max", 16), Integer.getInteger("azure.segment.archive.writer.retries.intervalMs", 5000));

    public AzureSegmentArchiveWriter(CloudBlobDirectory archiveDirectory, IOMonitor ioMonitor, FileStoreMonitor monitor, WriteAccessController writeAccessController) {
        super(ioMonitor, monitor);
        this.archiveDirectory = archiveDirectory;
        this.writeAccessController = writeAccessController;
    }

    public String getName() {
        return AzureUtilities.getName(this.archiveDirectory);
    }

    protected void doWriteArchiveEntry(RemoteSegmentArchiveEntry indexEntry, byte[] data, int offset, int size) throws IOException {
        this.writeAccessController.checkWritingAllowed();
        long msb = indexEntry.getMsb();
        long lsb = indexEntry.getLsb();
        String segmentName = RemoteUtilities.getSegmentFileName((RemoteSegmentArchiveEntry)indexEntry);
        CloudBlockBlob blob = this.getBlob(segmentName);
        this.ioMonitor.beforeSegmentWrite(new File(blob.getName()), msb, lsb, size);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            blob.setMetadata(AzureBlobMetadata.toSegmentMetadata((RemoteSegmentArchiveEntry)indexEntry));
            blob.uploadFromByteArray(data, offset, size);
            blob.uploadMetadata();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        this.ioMonitor.afterSegmentWrite(new File(blob.getName()), msb, lsb, size, stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    protected Buffer doReadArchiveEntry(RemoteSegmentArchiveEntry indexEntry) throws IOException {
        Buffer buffer = RemoteUtilities.OFF_HEAP ? Buffer.allocateDirect((int)indexEntry.getLength()) : Buffer.allocate((int)indexEntry.getLength());
        AzureUtilities.readBufferFully(this.getBlob(RemoteUtilities.getSegmentFileName((RemoteSegmentArchiveEntry)indexEntry)), buffer);
        return buffer;
    }

    protected void doWriteDataFile(byte[] data, String extension) throws IOException {
        this.retrier.execute(() -> {
            try {
                this.writeAccessController.checkWritingAllowed();
                this.getBlob(this.getName() + extension).uploadFromByteArray(data, 0, data.length);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        });
    }

    protected void afterQueueClosed() throws IOException {
        this.retrier.execute(() -> {
            try {
                this.writeAccessController.checkWritingAllowed();
                this.getBlob("closed").uploadFromByteArray(new byte[0], 0, 0);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        });
    }

    protected void afterQueueFlushed() {
    }

    private CloudBlockBlob getBlob(String name) throws IOException {
        try {
            return this.archiveDirectory.getBlockBlobReference(name);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

