/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.spi.RepositoryNotReachableException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AzureUtilities {
    private static final Logger log = LoggerFactory.getLogger(AzureUtilities.class);

    private AzureUtilities() {
    }

    public static String getName(CloudBlob blob) {
        return Paths.get(blob.getName(), new String[0]).getFileName().toString();
    }

    public static String getName(CloudBlobDirectory directory) {
        return Paths.get(directory.getUri().getPath(), new String[0]).getFileName().toString();
    }

    public static List<CloudBlob> getBlobs(CloudBlobDirectory directory) throws IOException {
        ResultSegment<ListBlobItem> result;
        ArrayList<CloudBlob> blobList = new ArrayList<CloudBlob>();
        ResultContinuation token = null;
        do {
            result = AzureUtilities.listBlobsInSegments(directory, token);
            for (ListBlobItem b : result.getResults()) {
                if (!(b instanceof CloudBlob)) continue;
                CloudBlob cloudBlob = (CloudBlob)b;
                blobList.add(cloudBlob);
            }
        } while ((token = result.getContinuationToken()) != null);
        return blobList;
    }

    public static void readBufferFully(CloudBlob blob, Buffer buffer) throws IOException {
        try {
            blob.download(new ByteBufferOutputStream(buffer));
            buffer.flip();
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 404) {
                log.error("Blob not found in the remote repository: {}", (Object)blob.getName());
                throw new FileNotFoundException("Blob not found in the remote repository: " + blob.getName());
            }
            throw new RepositoryNotReachableException((Throwable)e);
        }
    }

    public static void deleteAllEntries(CloudBlobDirectory directory) throws IOException {
        AzureUtilities.getBlobs(directory).forEach(b -> {
            try {
                b.deleteIfExists();
            }
            catch (StorageException e) {
                log.error("Can't delete blob {}", (Object)b.getUri().getPath(), (Object)e);
            }
        });
    }

    public static CloudBlobDirectory cloudBlobDirectoryFrom(StorageCredentials credentials, String uri, String dir) throws URISyntaxException, StorageException {
        StorageUri storageUri = new StorageUri(new URI(uri));
        CloudBlobContainer container = new CloudBlobContainer(storageUri, credentials);
        container.createIfNotExists();
        return container.getDirectoryReference(dir);
    }

    public static CloudBlobDirectory cloudBlobDirectoryFrom(String connection, String containerName, String dir) throws InvalidKeyException, URISyntaxException, StorageException {
        CloudStorageAccount cloud = CloudStorageAccount.parse(connection);
        CloudBlobContainer container = cloud.createCloudBlobClient().getContainerReference(containerName);
        container.createIfNotExists();
        return container.getDirectoryReference(dir);
    }

    private static ResultSegment<ListBlobItem> listBlobsInSegments(CloudBlobDirectory directory, ResultContinuation token) throws IOException {
        ResultSegment<ListBlobItem> result = null;
        IOException lastException = null;
        for (int sleep = 10; sleep <= 10000; sleep *= 10) {
            try {
                result = directory.listBlobsSegmented(null, false, EnumSet.of(BlobListingDetails.METADATA), 5000, token, null, null);
                break;
            }
            catch (StorageException | URISyntaxException e) {
                lastException = new IOException(e);
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ex) {
                    log.warn("Interrupted", (Throwable)e);
                }
                continue;
            }
        }
        if (result == null) {
            throw lastException;
        }
        return result;
    }

    private static class ByteBufferOutputStream
    extends OutputStream {
        @NotNull
        private final Buffer buffer;

        public ByteBufferOutputStream(@NotNull Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.put((byte)b);
        }

        @Override
        public void write(@NotNull byte[] bytes, int offset, int length) {
            this.buffer.put(bytes, offset, length);
        }
    }
}

