/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(pid={"org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService"}, name="Apache Jackrabbit Oak Azure Segment Store Service", description="Azure backend for the Oak Segment Node Store")
@interface Configuration {
    public static final String PID = "org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService";

    @AttributeDefinition(name="Azure account name", description="Name of the Azure Storage account to use.")
    public String accountName();

    @AttributeDefinition(name="Azure container name", description="Name of the container to use. If it doesn't exists, it'll be created.")
    public String containerName() default "oak";

    @AttributeDefinition(name="Azure account access key", description="Access key which should be used to authenticate on the account")
    public String accessKey();

    @AttributeDefinition(name="Root path", description="Names of all the created blobs will be prefixed with this path")
    public String rootPath() default "/oak";

    @AttributeDefinition(name="Azure connection string (optional)", description="Connection string to be used to connect to the Azure Storage. Setting it will take precedence over accountName/accessKey and sharedAccessSignature properties.")
    public String connectionURL() default "";

    @AttributeDefinition(name="Azure Shared Access Signature (optional)", description="Shared Access Signature string to be used to connect to the Azure Storage. Setting it will take precedence over accountName/accessKey properties.")
    public String sharedAccessSignature() default "";

    @AttributeDefinition(name="Azure Blob Endpoint URL (optional)", description="Blob Endpoint URL used to connect to the Azure Storage")
    public String blobEndpoint() default "";

    @AttributeDefinition(name="Role", description="The role of this persistence. It should be unique and may be used to filter services in order to create services composed of multiple persistence instances. E.g. a SplitPersistence composed of a TAR persistence and an Azure persistence.")
    public String role() default "";

    @AttributeDefinition(name="Azure segment store property to enable fallback to the secondary location", description="When set to true specifies that requests will be attempted in primary, then in secondary region.Default value is 'false'.")
    public boolean enableSecondaryLocation() default false;
}

