/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ReverseFileReader {
    private static final int BUFFER_SIZE = 16384;
    private int bufferSize;
    private final CloudBlob blob;
    private byte[] buffer;
    private int bufferOffset;
    private int fileOffset;

    public ReverseFileReader(CloudBlob blob) throws StorageException {
        this(blob, 16384);
    }

    public ReverseFileReader(CloudBlob blob, int bufferSize) throws StorageException {
        this.blob = blob;
        this.fileOffset = blob.exists() ? (int)blob.getProperties().getLength() : 0;
        this.bufferSize = bufferSize;
    }

    private void readBlock() throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[Math.min(this.fileOffset, this.bufferSize)];
        } else if (this.fileOffset < this.buffer.length) {
            this.buffer = new byte[this.fileOffset];
        }
        if (this.buffer.length > 0) {
            this.fileOffset -= this.buffer.length;
            try {
                OperationContext opContext = new OperationContext();
                HashMap<String, String> userHeaders = new HashMap<String, String>();
                userHeaders.put("If-Match", "*");
                opContext.setUserHeaders(userHeaders);
                this.blob.downloadRangeToByteArray(this.fileOffset, Long.valueOf(this.buffer.length), this.buffer, 0, null, null, opContext);
            }
            catch (StorageException e) {
                throw new IOException(e);
            }
        }
        this.bufferOffset = this.buffer.length;
    }

    private String readUntilNewLine() {
        if (this.bufferOffset == -1) {
            return "";
        }
        int stop = this.bufferOffset;
        while (--this.bufferOffset >= 0 && this.buffer[this.bufferOffset] != 10) {
        }
        return new String(this.buffer, this.bufferOffset + 1, stop - this.bufferOffset - 1, Charset.defaultCharset());
    }

    public String readLine() throws IOException {
        if (this.bufferOffset == -1 && this.fileOffset == 0) {
            return null;
        }
        if (this.buffer == null) {
            this.readBlock();
        }
        ArrayList<String> result = new ArrayList<String>(1);
        while (true) {
            result.add(this.readUntilNewLine());
            if (this.bufferOffset > -1 || this.fileOffset == 0) break;
            this.readBlock();
        }
        Collections.reverse(result);
        return String.join((CharSequence)"", result);
    }
}

