/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.util;

import java.io.IOException;
import org.apache.jackrabbit.oak.segment.spi.RepositoryNotReachableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier {
    private static final Logger log = LoggerFactory.getLogger(Retrier.class);
    private final int maxAttempts;
    private final int intervalMs;

    Retrier(int maxAttempts, int intervalMs) {
        this.maxAttempts = maxAttempts;
        this.intervalMs = intervalMs;
    }

    public static Retrier withParams(int maxAttempts, int intervalMs) {
        return new Retrier(maxAttempts, intervalMs);
    }

    public <T> T execute(ThrowingSupplier<T> supplier) throws IOException {
        for (int attempt = 1; attempt <= this.maxAttempts; ++attempt) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                if (attempt == this.maxAttempts) {
                    log.error("Can't execute the operation (attempt {}/{}). Reason: {}", new Object[]{attempt, this.maxAttempts, e.getMessage()});
                    throw e;
                }
                if (!(e instanceof IOException) && !(e instanceof RepositoryNotReachableException)) {
                    throw new RuntimeException("Unexpected exception while executing the operation", e);
                }
                log.error("Can't execute the operation (attempt {}/{}). Retrying in {} ms...", new Object[]{attempt, this.maxAttempts, this.intervalMs, e});
                try {
                    Thread.sleep(this.intervalMs);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Retries interrupted");
                }
            }
        }
        throw new AssertionError((Object)"Should never reach here");
    }

    public void execute(ThrowingRunnable runnable) throws IOException {
        this.execute(() -> {
            runnable.run();
            return null;
        });
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws IOException;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws IOException;
    }
}

