/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;

public abstract class AbstractRemoteSegmentArchiveReader
implements SegmentArchiveReader {
    protected final IOMonitor ioMonitor;
    protected final Map<UUID, RemoteSegmentArchiveEntry> index = new LinkedHashMap<UUID, RemoteSegmentArchiveEntry>();
    protected Boolean hasGraph;

    public AbstractRemoteSegmentArchiveReader(IOMonitor ioMonitor) throws IOException {
        this.ioMonitor = ioMonitor;
    }

    public Buffer readSegment(long msb, long lsb) throws IOException {
        RemoteSegmentArchiveEntry indexEntry = this.index.get(new UUID(msb, lsb));
        if (indexEntry == null) {
            return null;
        }
        Buffer buffer = RemoteUtilities.OFF_HEAP ? Buffer.allocateDirect((int)indexEntry.getLength()) : Buffer.allocate((int)indexEntry.getLength());
        this.ioMonitor.beforeSegmentRead(this.archivePathAsFile(), msb, lsb, indexEntry.getLength());
        Stopwatch stopwatch = Stopwatch.createStarted();
        String segmentFileName = RemoteUtilities.getSegmentFileName(indexEntry);
        this.doReadSegmentToBuffer(segmentFileName, buffer);
        long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.ioMonitor.afterSegmentRead(this.archivePathAsFile(), msb, lsb, indexEntry.getLength(), elapsed);
        return buffer;
    }

    public boolean containsSegment(long msb, long lsb) {
        return this.index.containsKey(new UUID(msb, lsb));
    }

    public List<SegmentArchiveEntry> listSegments() {
        return new ArrayList<SegmentArchiveEntry>(this.index.values());
    }

    public Buffer getGraph() throws IOException {
        Buffer graph = this.doReadDataFile(".gph");
        this.hasGraph = graph != null;
        return graph;
    }

    public boolean hasGraph() {
        if (this.hasGraph == null) {
            try {
                this.getGraph();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hasGraph != null ? this.hasGraph : false;
    }

    public Buffer getBinaryReferences() throws IOException {
        return this.doReadDataFile(".brf");
    }

    public void close() {
    }

    public int getEntrySize(int size) {
        return size;
    }

    protected abstract long computeArchiveIndexAndLength() throws IOException;

    protected abstract void doReadSegmentToBuffer(String var1, Buffer var2) throws IOException;

    protected abstract Buffer doReadDataFile(String var1) throws IOException;

    protected abstract File archivePathAsFile();

    public boolean isRemote() {
        return true;
    }
}

