/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote.persistentcache;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(pid={"org.apache.jackrabbit.oak.segment.remote.RemotePersistentCacheService"}, name="Apache Jackrabbit Oak Remote Persistent Cache Service", description="Persistent cache for the Oak Segment Node Store")
public @interface Configuration {
    public static final String PID = "org.apache.jackrabbit.oak.segment.remote.RemotePersistentCacheService";

    @AttributeDefinition(name="Disk cache persistence", description="Boolean value indicating that the local disk persisted cache should be used for segment store")
    public boolean diskCacheEnabled() default false;

    @AttributeDefinition(name="Disk cache persistence directory", description="Path on the file system where disk cache persistence data will be stored.")
    public String diskCacheDirectory() default "";

    @AttributeDefinition(name="Disk cache persistence maximum size", description="Disk cache size (in MB). Default value is 512")
    public int diskCacheMaxSizeMB() default 512;

    @AttributeDefinition(name="Redis cache persistence", description="Boolean value indicating that the redis persisted cache should be used for segment store")
    public boolean redisCacheEnabled() default false;

    @AttributeDefinition(name="Redis cache persistence host", description="Remote redis server host")
    public String redisCacheHost() default "";

    @AttributeDefinition(name="Redis cache persistence port", description="Remote redis server port (0 = default)")
    public int redisCachePort() default 0;

    @AttributeDefinition(name="Redis cache persistence entries expiry interval", description="Number of seconds to keep the entries in the cache. Default value is 172800")
    public int redisCacheExpireSeconds() default 172800;

    @AttributeDefinition(name="Redis cache db index", description="Redis cache db index (see Jedis#select(int))")
    public int redisDBIndex() default 1;

    @AttributeDefinition(name="Redis socket timeout", description="Number of seconds to wait for response for request")
    public int redisSocketTimeout() default 10;

    @AttributeDefinition(name="Redis connection timeout", description="Number of milliseconds to wait for redis connection to be established")
    public int redisConnectionTimeout() default 5000;

    @AttributeDefinition(name="Redis Minimum Connections", description="Minimum number of established connections that need to be kept in the pool")
    public int redisMinConnections() default 10;

    @AttributeDefinition(name="Redis Maximum Connections", description="Maximum number of connections required by the business")
    public int redisMaxConnections() default 100;

    @AttributeDefinition(name="Redis Maximum Total Connections", description="Includes the number of idle connections as a surplus")
    public int redisMaxTotalConnections() default 200;
}

