/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote.persistentcache;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.Configuration;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.DiskCacheIOMonitor;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.PersistentDiskCache;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.PersistentRedisCache;
import org.apache.jackrabbit.oak.segment.remote.persistentcache.RedisCacheIOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RoleStatisticsProvider;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.jackrabbit.oak.segment.remote.RemotePersistentCacheService"})
public class RemotePersistentCacheService {
    private ServiceRegistration registration;
    private PersistentCache persistentCache;
    private final Closer closer = Closer.create();
    private OsgiWhiteboard osgiWhiteboard;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;

    @Activate
    public void activate(ComponentContext context, Configuration config) throws IOException {
        this.osgiWhiteboard = new OsgiWhiteboard(context.getBundleContext());
        this.persistentCache = this.createPersistentCache(config, this.closer);
        if (this.persistentCache != null) {
            this.registration = context.getBundleContext().registerService(PersistentCache.class, (Object)this.persistentCache, new Hashtable());
        }
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        IOUtils.closeQuietly((Closeable)this.closer);
        this.persistentCache = null;
    }

    protected void registerCloseable(Registration registration) {
        this.closer.register(() -> ((Registration)registration).unregister());
    }

    protected <T> Registration registerMBean(Class<T> clazz, T bean, String type, String name) {
        return WhiteboardUtils.registerMBean((Whiteboard)this.osgiWhiteboard, clazz, bean, (String)type, (String)name);
    }

    private PersistentCache createPersistentCache(Configuration configuration, Closer closer) {
        RoleStatisticsProvider roleStatisticsProvider = new RoleStatisticsProvider(this.statisticsProvider, "remote_persistence");
        DiskCacheIOMonitor diskCacheIOMonitor = new DiskCacheIOMonitor((StatisticsProvider)roleStatisticsProvider);
        RedisCacheIOMonitor redisCacheIOMonitor = new RedisCacheIOMonitor((StatisticsProvider)roleStatisticsProvider);
        if (configuration.diskCacheEnabled()) {
            PersistentDiskCache persistentDiskCache = new PersistentDiskCache(new File(configuration.diskCacheDirectory()), configuration.diskCacheMaxSizeMB(), (IOMonitor)diskCacheIOMonitor);
            closer.register((Closeable)((Object)persistentDiskCache));
            AbstractCacheStats diskCacheStatsMBean = persistentDiskCache.getCacheStats();
            this.registerCloseable(this.registerMBean(CacheStatsMBean.class, diskCacheStatsMBean, "CacheStats", diskCacheStatsMBean.getName()));
            if (configuration.redisCacheEnabled()) {
                PersistentRedisCache redisCache = new PersistentRedisCache(configuration.redisCacheHost(), configuration.redisCachePort(), configuration.redisCacheExpireSeconds(), configuration.redisSocketTimeout(), configuration.redisConnectionTimeout(), configuration.redisMinConnections(), configuration.redisMaxConnections(), configuration.redisMaxTotalConnections(), configuration.redisDBIndex(), (IOMonitor)redisCacheIOMonitor);
                persistentDiskCache.linkWith(redisCache);
                closer.register((Closeable)((Object)redisCache));
                AbstractCacheStats redisCacheStatsMBean = redisCache.getCacheStats();
                this.registerCloseable(this.registerMBean(CacheStatsMBean.class, redisCacheStatsMBean, "CacheStats", redisCacheStatsMBean.getName()));
            }
            return persistentDiskCache;
        }
        if (configuration.redisCacheEnabled()) {
            PersistentRedisCache redisCache = new PersistentRedisCache(configuration.redisCacheHost(), configuration.redisCachePort(), configuration.redisCacheExpireSeconds(), configuration.redisSocketTimeout(), configuration.redisConnectionTimeout(), configuration.redisMinConnections(), configuration.redisMaxConnections(), configuration.redisMaxTotalConnections(), configuration.redisDBIndex(), (IOMonitor)redisCacheIOMonitor);
            closer.register((Closeable)((Object)redisCache));
            AbstractCacheStats redisCacheStatsMBean = redisCache.getCacheStats();
            this.registerCloseable(this.registerMBean(CacheStatsMBean.class, redisCacheStatsMBean, "CacheStats", redisCacheStatsMBean.getName()));
            return redisCache;
        }
        return null;
    }
}

