/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentCache;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.EstimationResult;
import org.apache.jackrabbit.oak.segment.file.EstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.FileStoreStats;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.GCMemoryBarrier;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.SegmentWriterFactory;
import org.apache.jackrabbit.oak.segment.file.SuccessfulCompactionListener;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

abstract class AbstractGarbageCollectionStrategy
implements GarbageCollectionStrategy {
    AbstractGarbageCollectionStrategy() {
    }

    abstract EstimationStrategy getFullEstimationStrategy();

    abstract EstimationStrategy getTailEstimationStrategy();

    abstract CompactionStrategy getFullCompactionStrategy();

    abstract CompactionStrategy getTailCompactionStrategy();

    abstract CleanupStrategy getCleanupStrategy();

    @Override
    public void collectGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        switch (context.getGCOptions().getGCType()) {
            case FULL: {
                this.collectFullGarbage(context);
                break;
            }
            case TAIL: {
                this.collectTailGarbage(context);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid GC type");
            }
        }
    }

    @Override
    public void collectFullGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        this.run(context, this.getFullEstimationStrategy(), this.getFullCompactionStrategy());
    }

    @Override
    public void collectTailGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        this.run(context, this.getTailEstimationStrategy(), this.getTailCompactionStrategy());
    }

    @Override
    public CompactionResult compactFull(GarbageCollectionStrategy.Context context) throws IOException {
        return this.getFullCompactionStrategy().compact(AbstractGarbageCollectionStrategy.newCompactionStrategyContext(context));
    }

    @Override
    public CompactionResult compactTail(GarbageCollectionStrategy.Context context) throws IOException {
        return this.getTailCompactionStrategy().compact(AbstractGarbageCollectionStrategy.newCompactionStrategyContext(context));
    }

    @Override
    public List<String> cleanup(GarbageCollectionStrategy.Context context) throws IOException {
        return this.cleanup(context, CompactionResult.skipped(context.getLastCompactionType(), this.getGcGeneration(context), context.getGCOptions(), context.getRevisions().getHead(), context.getGCCount()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(GarbageCollectionStrategy.Context context, EstimationStrategy estimationStrategy, CompactionStrategy compactionStrategy) throws IOException {
        block29: {
            try {
                context.getGCListener().info("started", new Object[0]);
                long dt = System.currentTimeMillis() - context.getLastSuccessfulGC();
                if (dt < context.getGCBackOff()) {
                    context.getGCListener().skipped("skipping garbage collection as it already ran less than {} hours ago ({} s).", new Object[]{context.getGCBackOff() / 3600000L, dt / 1000L});
                    return;
                }
                boolean sufficientEstimatedGain = true;
                if (context.getGCOptions().isEstimationDisabled()) {
                    context.getGCListener().info("estimation skipped because it was explicitly disabled", new Object[0]);
                } else if (context.getGCOptions().isPaused()) {
                    context.getGCListener().info("estimation skipped because compaction is paused", new Object[0]);
                } else {
                    context.getGCListener().info("estimation started", new Object[0]);
                    context.getGCListener().updateStatus(SegmentGCStatus.ESTIMATION.message());
                    PrintableStopwatch watch = PrintableStopwatch.createStarted();
                    EstimationResult estimation = estimationStrategy.estimate(this.newEstimationStrategyContext(context));
                    sufficientEstimatedGain = estimation.isGcNeeded();
                    String gcLog = estimation.getGcLog();
                    if (sufficientEstimatedGain) {
                        context.getGCListener().info("estimation completed in {}. {}", new Object[]{watch, gcLog});
                    } else {
                        context.getGCListener().skipped("estimation completed in {}. {}", new Object[]{watch, gcLog});
                    }
                }
                if (!sufficientEstimatedGain) break block29;
                try (GCMemoryBarrier ignored = new GCMemoryBarrier(context.getSufficientMemory(), context.getGCListener(), context.getGCOptions());){
                    if (context.getGCOptions().isPaused()) {
                        context.getGCListener().skipped("compaction paused", new Object[0]);
                    } else if (!context.getSufficientMemory().get()) {
                        context.getGCListener().skipped("compaction skipped. Not enough memory", new Object[0]);
                    } else {
                        CompactionResult compactionResult = compactionStrategy.compact(AbstractGarbageCollectionStrategy.newCompactionStrategyContext(context));
                        if (compactionResult.isSuccess()) {
                            context.getSuccessfulGarbageCollectionListener().onSuccessfulGarbageCollection();
                        } else {
                            context.getGCListener().info("cleaning up after failed compaction", new Object[0]);
                        }
                        context.getFileReaper().add(this.cleanup(context, compactionResult));
                    }
                }
            }
            finally {
                context.getCompactionMonitor().finished();
                context.getGCListener().updateStatus(SegmentGCStatus.IDLE.message());
            }
        }
    }

    private GCGeneration getGcGeneration(GarbageCollectionStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }

    private List<String> cleanup(GarbageCollectionStrategy.Context context, CompactionResult compactionResult) throws IOException {
        return this.getCleanupStrategy().cleanup(this.newCleanupStrategyContext(context, compactionResult));
    }

    private EstimationStrategy.Context newEstimationStrategyContext(final GarbageCollectionStrategy.Context context) {
        return new EstimationStrategy.Context(){

            @Override
            public long getSizeDelta() {
                return context.getGCOptions().getGcSizeDeltaEstimation();
            }

            @Override
            public long getCurrentSize() {
                return context.getTarFiles().size();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }
        };
    }

    private static CompactionStrategy.Context newCompactionStrategyContext(final GarbageCollectionStrategy.Context context) {
        return new CompactionStrategy.Context(){

            @Override
            public SegmentTracker getSegmentTracker() {
                return context.getSegmentTracker();
            }

            @Override
            public GCListener getGCListener() {
                return context.getGCListener();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }

            @Override
            public SegmentGCOptions getGCOptions() {
                return context.getGCOptions();
            }

            @Override
            public GCNodeWriteMonitor getCompactionMonitor() {
                return context.getCompactionMonitor();
            }

            @Override
            public SegmentReader getSegmentReader() {
                return context.getSegmentReader();
            }

            @Override
            public SegmentWriterFactory getSegmentWriterFactory() {
                return context.getSegmentWriterFactory();
            }

            @Override
            public Revisions getRevisions() {
                return context.getRevisions();
            }

            @Override
            public TarFiles getTarFiles() {
                return context.getTarFiles();
            }

            @Override
            public BlobStore getBlobStore() {
                return context.getBlobStore();
            }

            @Override
            public Canceller getCanceller() {
                return context.getCanceller();
            }

            @Override
            public int getGCCount() {
                return context.getGCCount();
            }

            @Override
            public SuccessfulCompactionListener getSuccessfulCompactionListener() {
                return context.getSuccessfulCompactionListener();
            }

            @Override
            public Flusher getFlusher() {
                return context.getFlusher();
            }
        };
    }

    private CleanupStrategy.Context newCleanupStrategyContext(final GarbageCollectionStrategy.Context context, final CompactionResult compactionResult) {
        return new CleanupStrategy.Context(){

            @Override
            public GCListener getGCListener() {
                return context.getGCListener();
            }

            @Override
            public SegmentCache getSegmentCache() {
                return context.getSegmentCache();
            }

            @Override
            public SegmentTracker getSegmentTracker() {
                return context.getSegmentTracker();
            }

            @Override
            public FileStoreStats getFileStoreStats() {
                return context.getFileStoreStats();
            }

            @Override
            public GCNodeWriteMonitor getCompactionMonitor() {
                return context.getCompactionMonitor();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }

            @Override
            public Predicate<GCGeneration> getReclaimer() {
                return compactionResult.reclaimer();
            }

            @Override
            public TarFiles getTarFiles() {
                return context.getTarFiles();
            }

            @Override
            public Revisions getRevisions() {
                return context.getRevisions();
            }

            @Override
            public String getCompactedRootId() {
                return compactionResult.getCompactedRootId().toString10();
            }

            @Override
            public String getSegmentEvictionReason() {
                return compactionResult.gcInfo();
            }
        };
    }
}

