/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.segment.file.EstimationResult;
import org.apache.jackrabbit.oak.segment.file.EstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;

class FullSizeDeltaEstimationStrategy
implements EstimationStrategy {
    FullSizeDeltaEstimationStrategy() {
    }

    @Override
    public EstimationResult estimate(EstimationStrategy.Context context) {
        if (context.getSizeDelta() == 0L) {
            return new EstimationResult(true, "Estimation skipped because the size delta value equals 0");
        }
        long previousSize = this.readPreviousSize(context);
        if (previousSize < 0L) {
            return new EstimationResult(true, "Estimation skipped because of missing gc journal data (expected on first run)");
        }
        if (this.previousIsTail(context)) {
            return new EstimationResult(true, "Detected previous garbage collection of type tail so running full garbage collection now.");
        }
        long gain = context.getCurrentSize() - previousSize;
        boolean gcNeeded = gain > context.getSizeDelta();
        String gcInfo = String.format("Segmentstore size has increased since the last full garbage collection from %s to %s, an increase of %s or %s%%. ", PrintableBytes.newPrintableBytes(previousSize), PrintableBytes.newPrintableBytes(context.getCurrentSize()), PrintableBytes.newPrintableBytes(gain), 100L * gain / previousSize);
        gcInfo = gcNeeded ? gcInfo + String.format("This is greater than sizeDeltaEstimation=%s, so running garbage collection", PrintableBytes.newPrintableBytes(context.getSizeDelta())) : gcInfo + String.format("This is less than sizeDeltaEstimation=%s, so skipping garbage collection", PrintableBytes.newPrintableBytes(context.getSizeDelta()));
        return new EstimationResult(gcNeeded, gcInfo);
    }

    private long readPreviousSize(EstimationStrategy.Context context) {
        ArrayList<GCJournal.GCJournalEntry> entries = new ArrayList<GCJournal.GCJournalEntry>(context.getGCJournal().readAll());
        if (entries.isEmpty()) {
            return -1L;
        }
        entries.sort((a, b) -> {
            if (a.getGcGeneration().getFullGeneration() > b.getGcGeneration().getFullGeneration()) {
                return -1;
            }
            if (a.getGcGeneration().getFullGeneration() < b.getGcGeneration().getFullGeneration()) {
                return 1;
            }
            return Integer.compare(a.getGcGeneration().getGeneration(), b.getGcGeneration().getGeneration());
        });
        return ((GCJournal.GCJournalEntry)entries.iterator().next()).getRepoSize();
    }

    private boolean previousIsTail(EstimationStrategy.Context context) {
        int n;
        ArrayList entries = Lists.newArrayList(context.getGCJournal().readAll());
        if (entries.isEmpty()) {
            return true;
        }
        if (entries.size() == 1) {
            return false;
        }
        int m = ((GCJournal.GCJournalEntry)entries.get(entries.size() - 2)).getGcGeneration().getFullGeneration();
        return m == (n = ((GCJournal.GCJournalEntry)entries.get(entries.size() - 1)).getGcGeneration().getFullGeneration());
    }
}

