/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import java.util.Arrays;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.file.proc.RecordsNode;
import org.apache.jackrabbit.oak.segment.file.proc.ReferencesNode;
import org.apache.jackrabbit.oak.segment.file.proc.SegmentBlob;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

class DataSegmentNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String segmentId;
    private final Proc.Backend.Segment segment;

    DataSegmentNode(Proc.Backend backend, String segmentId, Proc.Backend.Segment segment) {
        this.backend = backend;
        this.segmentId = segmentId;
        this.segment = segment;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return Arrays.asList(PropertyStates.createProperty((String)"generation", (Object)this.segment.getGeneration(), (Type)Type.LONG), PropertyStates.createProperty((String)"fullGeneration", (Object)this.segment.getFullGeneration(), (Type)Type.LONG), PropertyStates.createProperty((String)"compacted", (Object)this.segment.isCompacted(), (Type)Type.BOOLEAN), PropertyStates.createProperty((String)"length", (Object)this.segment.getLength(), (Type)Type.LONG), PropertyStates.createProperty((String)"data", (Object)new SegmentBlob(this.backend, this.segmentId, this.segment), (Type)Type.BINARY), PropertyStates.createProperty((String)"version", (Object)this.segment.getVersion(), (Type)Type.LONG), PropertyStates.createProperty((String)"isDataSegment", (Object)true, (Type)Type.BOOLEAN), PropertyStates.createProperty((String)"info", (Object)this.segment.getInfo().orElse(""), (Type)Type.STRING), PropertyStates.createProperty((String)"id", (Object)this.segmentId, (Type)Type.STRING), PropertyStates.createProperty((String)"exists", (Object)true, (Type)Type.BOOLEAN));
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return Arrays.asList(new MemoryChildNodeEntry("references", (NodeState)new ReferencesNode(this.backend, this.segmentId)), new MemoryChildNodeEntry("records", (NodeState)new RecordsNode(this.backend, this.segmentId)));
    }
}

