/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.monitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.jetbrains.annotations.NotNull;

public class CompositeIOMonitor
implements IOMonitor {
    private final Set<IOMonitor> ioMonitors;

    public CompositeIOMonitor(@NotNull Iterable<? extends IOMonitor> ioMonitors) {
        this.ioMonitors = Sets.newConcurrentHashSet((Iterable)((Iterable)Preconditions.checkNotNull(ioMonitors)));
    }

    public CompositeIOMonitor() {
        this(Collections.emptySet());
    }

    @NotNull
    public Registration registerIOMonitor(@NotNull IOMonitor ioMonitor) {
        this.ioMonitors.add((IOMonitor)Preconditions.checkNotNull((Object)ioMonitor));
        return () -> this.ioMonitors.remove(ioMonitor);
    }

    @Override
    public void beforeSegmentRead(File file, long msb, long lsb, int length) {
        this.ioMonitors.forEach(ioMonitor -> ioMonitor.beforeSegmentRead(file, msb, lsb, length));
    }

    @Override
    public void afterSegmentRead(File file, long msb, long lsb, int length, long elapsed) {
        this.ioMonitors.forEach(ioMonitor -> ioMonitor.afterSegmentRead(file, msb, lsb, length, elapsed));
    }

    @Override
    public void beforeSegmentWrite(File file, long msb, long lsb, int length) {
        this.ioMonitors.forEach(ioMonitor -> ioMonitor.beforeSegmentWrite(file, msb, lsb, length));
    }

    @Override
    public void afterSegmentWrite(File file, long msb, long lsb, int length, long elapsed) {
        this.ioMonitors.forEach(ioMonitor -> ioMonitor.afterSegmentWrite(file, msb, lsb, length, elapsed));
    }
}

