/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentReferences;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;

class SegmentDump {
    SegmentDump() {
    }

    private static int getAddress(int length, int offset) {
        return length - (262144 - offset);
    }

    static String dumpSegment(SegmentId id, int length, String segmentInfo, GCGeneration generation, SegmentReferences segmentReferences, RecordNumbers recordNumbers, Consumer<OutputStream> dumper) {
        StringWriter string = new StringWriter();
        try (PrintWriter writer = new PrintWriter(string);){
            writer.format("Segment %s (%d bytes)%n", id, length);
            if (segmentInfo != null) {
                writer.format("Info: %s, Generation: %s%n", segmentInfo, generation);
            }
            if (id != null && id.isDataSegmentId()) {
                writer.println("--------------------------------------------------------------------------");
                int i = 1;
                for (SegmentId segmentId : segmentReferences) {
                    writer.format("reference %02x: %s%n", i++, segmentId);
                }
                for (RecordNumbers.Entry entry : recordNumbers) {
                    int offset = entry.getOffset();
                    writer.format("%10s record %08x: %08x @ %08x%n", new Object[]{entry.getType(), entry.getRecordNumber(), offset, SegmentDump.getAddress(length, offset)});
                }
            }
            writer.println("--------------------------------------------------------------------------");
            dumper.accept((OutputStream)new WriterOutputStream((Writer)writer, Charsets.UTF_8));
            writer.println("--------------------------------------------------------------------------");
        }
        return string.toString();
    }
}

