/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import com.google.common.collect.Lists;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.file.proc.AbstractNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.jetbrains.annotations.NotNull;

class CommitNode
extends AbstractNode {
    private final Proc.Backend backend;
    private final String handle;

    CommitNode(Proc.Backend backend, String handle) {
        this.backend = backend;
        this.handle = handle;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        return this.backend.getCommit(this.handle).map(this::getProperties).orElse(Collections.emptySet());
    }

    private Iterable<PropertyState> getProperties(Proc.Backend.Commit entry) {
        return Lists.newArrayList((Object[])new PropertyState[]{PropertyStates.createProperty((String)"timestamp", (Object)entry.getTimestamp(), (Type)Type.LONG), PropertyStates.createProperty((String)"revision", (Object)entry.getRevision())});
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return this.backend.getCommit(this.handle).flatMap(Proc.Backend.Commit::getRoot).map(r -> Collections.singleton(new MemoryChildNodeEntry("root", r))).orElse(Collections.emptySet());
    }
}

