/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.ClassicCompactor;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckpointCompactor
implements Compactor {
    @NotNull
    private final GCMonitor gcListener;
    @NotNull
    private final Map<NodeState, NodeState> cpCache = Maps.newHashMap();
    @NotNull
    private final ClassicCompactor compactor;
    @NotNull
    private final NodeWriter nodeWriter;

    public CheckpointCompactor(@NotNull GCMonitor gcListener, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore, @NotNull GCNodeWriteMonitor compactionMonitor) {
        this.gcListener = gcListener;
        this.compactor = new ClassicCompactor(reader, writer, blobStore, compactionMonitor);
        this.nodeWriter = (node, stableId) -> {
            RecordId nodeId = writer.writeNode(node, stableId);
            return new SegmentNodeState(reader, writer, blobStore, nodeId);
        };
    }

    @Override
    @Nullable
    public SegmentNodeState compact(@NotNull NodeState base, @NotNull NodeState uncompacted, @NotNull NodeState onto, Canceller canceller) throws IOException {
        LinkedHashMap<String, NodeState> uncompactedRoots = this.collectRoots(uncompacted);
        LinkedHashMap<String, NodeState> compactedRoots = this.compact(CheckpointCompactor.getRoot(base), uncompactedRoots, CheckpointCompactor.getRoot(onto), canceller);
        if (compactedRoots == null) {
            return null;
        }
        NodeBuilder builder = uncompacted.builder();
        for (Map.Entry<String, NodeState> compactedRoot : compactedRoots.entrySet()) {
            String path = compactedRoot.getKey();
            NodeState state = compactedRoot.getValue();
            NodeBuilder childBuilder = CheckpointCompactor.getChild(builder, PathUtils.getParentPath((String)path));
            childBuilder.setChildNode(PathUtils.getName((String)path), state);
        }
        return this.nodeWriter.writeNode(builder.getNodeState(), CheckpointCompactor.getStableIdBytes(uncompacted));
    }

    @Nullable
    private static Buffer getStableIdBytes(@NotNull NodeState node) {
        return node instanceof SegmentNodeState ? ((SegmentNodeState)node).getStableIdBytes() : null;
    }

    @NotNull
    private static NodeState getRoot(@NotNull NodeState node) {
        return node.hasChildNode("root") ? node.getChildNode("root") : EmptyNodeState.EMPTY_NODE;
    }

    @Nullable
    private LinkedHashMap<String, NodeState> compact(@NotNull NodeState base, @NotNull LinkedHashMap<String, NodeState> uncompactedRoots, @NotNull NodeState onto, Canceller canceller) throws IOException {
        LinkedHashMap compactedRoots = Maps.newLinkedHashMap();
        for (Map.Entry<String, NodeState> uncompactedRoot : uncompactedRoots.entrySet()) {
            String path = uncompactedRoot.getKey();
            NodeState uncompacted = uncompactedRoot.getValue();
            Result result = this.compactWithCache(base, uncompacted, onto, path, canceller);
            if (result == null) {
                return null;
            }
            base = result.nextBefore;
            onto = result.nextOnto;
            compactedRoots.put(path, result.compacted);
        }
        return compactedRoots;
    }

    @NotNull
    private LinkedHashMap<String, NodeState> collectRoots(@Nullable NodeState superRoot) {
        LinkedHashMap roots = Maps.newLinkedHashMap();
        if (superRoot != null) {
            ArrayList checkpoints = Lists.newArrayList((Iterable)superRoot.getChildNode("checkpoints").getChildNodeEntries());
            checkpoints.sort((cne1, cne2) -> {
                long c1 = cne1.getNodeState().getLong("created");
                long c2 = cne2.getNodeState().getLong("created");
                return Long.compare(c1, c2);
            });
            for (ChildNodeEntry checkpoint : checkpoints) {
                String name = checkpoint.getName();
                NodeState node = checkpoint.getNodeState();
                this.gcListener.info("found checkpoint {} created at {}.", new Object[]{name, new Date(node.getLong("created"))});
                roots.put("checkpoints/" + name + "/root", node.getChildNode("root"));
            }
            roots.put("root", superRoot.getChildNode("root"));
        }
        return roots;
    }

    @NotNull
    private static NodeBuilder getChild(NodeBuilder builder, String path) {
        for (String name : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    @Nullable
    private Result compactWithCache(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull String path, Canceller canceller) throws IOException {
        this.gcListener.info("compacting {}.", new Object[]{path});
        NodeState compacted = this.cpCache.get(after);
        if (compacted == null) {
            compacted = this.compactor.compact(before, after, onto, canceller);
            if (compacted == null) {
                return null;
            }
            this.cpCache.put(after, compacted);
            return new Result(compacted, after, compacted);
        }
        this.gcListener.info("found {} in cache.", new Object[]{path});
        return new Result(compacted, before, onto);
    }

    private static class Result {
        final NodeState compacted;
        final NodeState nextBefore;
        final NodeState nextOnto;

        Result(@NotNull NodeState compacted, @NotNull NodeState nextBefore, @NotNull NodeState nextOnto) {
            this.compacted = compacted;
            this.nextBefore = nextBefore;
            this.nextOnto = nextOnto;
        }
    }

    private static interface NodeWriter {
        @NotNull
        public SegmentNodeState writeNode(@NotNull NodeState var1, @Nullable Buffer var2) throws IOException;
    }
}

