/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.jackrabbit.oak.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.backup.impl.FileStoreRestoreImpl;

public class Restore {
    private final File source;
    private final File target;
    private final FileStoreRestore fileStoreRestore;

    public static Builder builder() {
        return new Builder();
    }

    private Restore(Builder builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.fileStoreRestore = builder.fileStoreRestore;
    }

    public int run() {
        try {
            this.fileStoreRestore.restore(this.source, this.target);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
    }

    public static class Builder {
        private File source;
        private File target;
        private final FileStoreRestore fileStoreRestore = new FileStoreRestoreImpl();

        private Builder() {
        }

        public Builder withSource(File source) {
            this.source = (File)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withTarget(File target) {
            this.target = (File)Preconditions.checkNotNull((Object)target);
            return this;
        }

        public Restore build() {
            Preconditions.checkNotNull((Object)this.source);
            Preconditions.checkNotNull((Object)this.target);
            return new Restore(this);
        }
    }
}

