/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.jetbrains.annotations.NotNull;

class CleanupFirstCompactionStrategy
implements CompactionStrategy {
    private final GarbageCollectionStrategy.Context parentContext;
    private final CompactionStrategy strategy;

    CleanupFirstCompactionStrategy(GarbageCollectionStrategy.Context parentContext, CompactionStrategy strategy) {
        this.parentContext = parentContext;
        this.strategy = strategy;
    }

    @Override
    public CompactionResult compact(CompactionStrategy.Context context) throws IOException {
        Predicate reclaimer;
        PrintableStopwatch watch = PrintableStopwatch.createStarted();
        GCGeneration currentGeneration = context.getRevisions().getHead().getSegmentId().getGcGeneration();
        switch (context.getGCOptions().getGCType()) {
            case FULL: {
                reclaimer = generation -> {
                    if (generation == null) {
                        return false;
                    }
                    if (generation.getFullGeneration() < currentGeneration.getFullGeneration()) {
                        return true;
                    }
                    if (generation.getFullGeneration() > currentGeneration.getFullGeneration()) {
                        return true;
                    }
                    return generation.getGeneration() < currentGeneration.getGeneration() && !generation.isCompacted();
                };
                break;
            }
            case TAIL: {
                reclaimer = generation -> {
                    if (generation == null) {
                        return false;
                    }
                    if (generation.getFullGeneration() < currentGeneration.getFullGeneration() - 1) {
                        return true;
                    }
                    if (generation.getFullGeneration() == currentGeneration.getFullGeneration() - 1) {
                        return !generation.isCompacted();
                    }
                    if (generation.getFullGeneration() > currentGeneration.getFullGeneration()) {
                        return true;
                    }
                    return generation.getGeneration() < currentGeneration.getGeneration() && !generation.isCompacted();
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid garbage collection type");
            }
        }
        context.getGCListener().info("pre-compaction cleanup started", new Object[0]);
        context.getGCListener().updateStatus(SegmentGCStatus.CLEANUP.message());
        System.gc();
        TarFiles.CleanupResult cleanupResult = context.getTarFiles().cleanup(CleanupFirstCompactionStrategy.newCleanupContext(context, (Predicate<GCGeneration>)reclaimer));
        if (cleanupResult.isInterrupted()) {
            context.getGCListener().info("cleanup interrupted", new Object[0]);
        }
        context.getSegmentTracker().clearSegmentIdTables(cleanupResult.getReclaimedSegmentIds(), "[pre-compaction cleanup]");
        context.getGCListener().info("cleanup marking files for deletion: {}", new Object[]{CleanupFirstCompactionStrategy.toFileNames(cleanupResult.getRemovableFiles())});
        long finalSize = context.getTarFiles().size();
        long reclaimedSize = cleanupResult.getReclaimedSize();
        this.parentContext.getFileStoreStats().reclaimed(reclaimedSize);
        context.getGCListener().cleaned(reclaimedSize, finalSize);
        context.getGCListener().info("pre-compaction cleanup completed in {}. Post cleanup size is {} and space reclaimed {}.", new Object[]{watch, PrintableBytes.newPrintableBytes(finalSize), PrintableBytes.newPrintableBytes(reclaimedSize)});
        this.parentContext.getFileReaper().add(cleanupResult.getRemovableFiles());
        return this.strategy.compact(context);
    }

    private static CleanupContext newCleanupContext(final CompactionStrategy.Context context, final Predicate<GCGeneration> old) {
        return new CleanupContext(){

            private boolean isUnreferencedBulkSegment(UUID id, boolean referenced) {
                return !SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && !referenced;
            }

            private boolean isOldDataSegment(UUID id, GCGeneration generation) {
                return SegmentId.isDataSegmentId(id.getLeastSignificantBits()) && old.apply((Object)generation);
            }

            @Override
            public Collection<UUID> initialReferences() {
                HashSet references = Sets.newHashSet();
                for (SegmentId id : context.getSegmentTracker().getReferencedSegmentIds()) {
                    if (!id.isBulkSegmentId()) continue;
                    references.add(id.asUUID());
                }
                return references;
            }

            @Override
            public boolean shouldReclaim(UUID id, GCGeneration generation, boolean referenced) {
                return this.isUnreferencedBulkSegment(id, referenced) || this.isOldDataSegment(id, generation);
            }

            @Override
            public boolean shouldFollow(UUID from, UUID to) {
                return !SegmentId.isDataSegmentId(to.getLeastSignificantBits());
            }
        };
    }

    private static String toFileNames(@NotNull List<String> files) {
        if (files.isEmpty()) {
            return "none";
        }
        return Joiner.on((String)",").join(files);
    }

    private static GCGeneration getGcGeneration(CompactionStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }

    private static long size(CompactionStrategy.Context context) {
        return context.getTarFiles().size();
    }
}

