/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.commons.Buffer;

public class IndexWriter {
    private final int blockSize;
    private final List<Entry> entries = new ArrayList<Entry>();

    public static IndexWriter newIndexWriter(int blockSize) {
        Preconditions.checkArgument((blockSize > 0 ? 1 : 0) != 0, (Object)"Invalid block size");
        return new IndexWriter(blockSize);
    }

    private IndexWriter(int blockSize) {
        this.blockSize = blockSize;
    }

    public void addEntry(long msb, long lsb, int offset, int size, int generation, int fullGeneration, boolean isCompacted) {
        Entry entry = new Entry();
        entry.msb = msb;
        entry.lsb = lsb;
        entry.offset = offset;
        entry.size = size;
        entry.generation = generation;
        entry.fullGeneration = fullGeneration;
        entry.isCompacted = isCompacted;
        this.entries.add(entry);
    }

    public byte[] write() {
        int dataSize = this.entries.size() * 33 + 16;
        int totalSize = (dataSize + this.blockSize - 1) / this.blockSize * this.blockSize;
        Buffer buffer = Buffer.allocate((int)totalSize);
        buffer.position(totalSize - dataSize);
        this.entries.sort((a, b) -> {
            if (a.msb < b.msb) {
                return -1;
            }
            if (a.msb > b.msb) {
                return 1;
            }
            if (a.lsb < b.lsb) {
                return -1;
            }
            if (a.lsb > b.lsb) {
                return 1;
            }
            return 0;
        });
        for (Entry entry : this.entries) {
            buffer.putLong(entry.msb);
            buffer.putLong(entry.lsb);
            buffer.putInt(entry.offset);
            buffer.putInt(entry.size);
            buffer.putInt(entry.generation);
            buffer.putInt(entry.fullGeneration);
            buffer.put((byte)(entry.isCompacted ? 1 : 0));
        }
        CRC32 checksum = new CRC32();
        checksum.update(buffer.array(), totalSize - dataSize, dataSize - 16);
        buffer.putInt((int)checksum.getValue());
        buffer.putInt(this.entries.size());
        buffer.putInt(totalSize);
        buffer.putInt(171002634);
        return buffer.array();
    }

    private static class Entry {
        long msb;
        long lsb;
        int offset;
        int size;
        int generation;
        int fullGeneration;
        boolean isCompacted;

        private Entry() {
        }
    }
}

