/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnclosedSegmentArchiveReader
implements SegmentArchiveReader {
    private final SegmentArchiveReader delegate;
    private static final Buffer EMPTY_BINARY_REF = Buffer.wrap((byte[])BinaryReferencesIndexWriter.newBinaryReferencesIndexWriter().write()).asReadOnlyBuffer();

    UnclosedSegmentArchiveReader(SegmentArchiveReader delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public Buffer readSegment(long msb, long lsb) throws IOException {
        return this.delegate.readSegment(msb, lsb);
    }

    @Override
    public boolean containsSegment(long msb, long lsb) {
        return this.delegate.containsSegment(msb, lsb);
    }

    @Override
    public List<SegmentArchiveEntry> listSegments() {
        return this.delegate.listSegments();
    }

    @Override
    @Nullable
    public Buffer getGraph() throws IOException {
        return this.delegate.getGraph();
    }

    @Override
    public boolean hasGraph() {
        return this.delegate.hasGraph();
    }

    @Override
    @NotNull
    public Buffer getBinaryReferences() throws IOException {
        Buffer buffer = this.delegate.getBinaryReferences();
        if (buffer == null) {
            return EMPTY_BINARY_REF;
        }
        return buffer;
    }

    @Override
    public long length() {
        return this.delegate.length();
    }

    @Override
    @NotNull
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int getEntrySize(int size) {
        return this.delegate.getEntrySize(size);
    }

    @Override
    public boolean isRemote() {
        return this.delegate.isRemote();
    }
}

