/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.segment.ApproximateCounter;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.CheckpointCompactor;
import org.apache.jackrabbit.oak.segment.CompactorUtils;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.CompactionWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParallelCompactor
extends CheckpointCompactor {
    private static final int EXPLORATION_LOWER_LIMIT = 10000;
    private static final int EXPLORATION_UPPER_LIMIT = 100000;
    private final int numWorkers;
    private final long totalSizeEstimate;
    @Nullable
    private ExecutorService executorService;

    public ParallelCompactor(@NotNull GCMonitor gcListener, @NotNull CompactionWriter writer, @NotNull GCNodeWriteMonitor compactionMonitor, int nThreads) {
        super(gcListener, writer, compactionMonitor);
        if (nThreads < 0) {
            nThreads += Runtime.getRuntime().availableProcessors() + 1;
        }
        this.numWorkers = Math.max(0, nThreads - 1);
        this.totalSizeEstimate = compactionMonitor.getEstimatedTotal();
    }

    private boolean initializeExecutor() {
        if (this.numWorkers <= 0) {
            this.gcListener.info("using sequential compaction.", new Object[0]);
            return false;
        }
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = Executors.newFixedThreadPool(this.numWorkers);
        }
        return true;
    }

    @Override
    @Nullable
    protected CompactedNodeState compactDownWithDelegate(@NotNull NodeState before, @NotNull NodeState after, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        if (this.initializeExecutor()) {
            return new CompactionHandler(after, hardCanceller, softCanceller).diff(before, after);
        }
        return super.compactDownWithDelegate(before, after, hardCanceller, softCanceller);
    }

    @Override
    @Nullable
    protected CompactedNodeState compactWithDelegate(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        if (this.initializeExecutor()) {
            return new CompactionHandler(onto, canceller).diff(before, after);
        }
        return super.compactWithDelegate(before, after, onto, canceller);
    }

    private class CompactionHandler {
        @NotNull
        private final NodeState base;
        @NotNull
        private final Canceller hardCanceller;
        @Nullable
        private final Canceller softCanceller;

        CompactionHandler(@NotNull NodeState base, Canceller hardCanceller) {
            this.base = base;
            this.hardCanceller = hardCanceller;
            this.softCanceller = null;
        }

        CompactionHandler(@NotNull NodeState base, @NotNull Canceller hardCanceller, Canceller softCanceller) {
            this.base = base;
            this.hardCanceller = hardCanceller;
            this.softCanceller = softCanceller;
        }

        @Nullable
        CompactedNodeState diff(@NotNull NodeState before, @NotNull NodeState after) throws IOException {
            CompactedNodeState compacted;
            Preconditions.checkNotNull((Object)ParallelCompactor.this.executorService);
            Preconditions.checkState((!ParallelCompactor.this.executorService.isShutdown() ? 1 : 0) != 0);
            ParallelCompactor.this.gcListener.info("compacting with {} threads.", new Object[]{ParallelCompactor.this.numWorkers + 1});
            ParallelCompactor.this.gcListener.info("exploring content tree to find subtrees for parallel compaction.", new Object[0]);
            ParallelCompactor.this.gcListener.info("target node count for expansion is {}.", new Object[]{10000});
            CompactionTree root = new CompactionTree(before, after, this.base);
            if (this.diff(0, Collections.singletonList(root)) && (compacted = root.compact()) != null) {
                return compacted;
            }
            try {
                ParallelCompactor.this.executorService.shutdown();
                if (!ParallelCompactor.this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    ParallelCompactor.this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                ParallelCompactor.this.executorService.shutdownNow();
            }
            return null;
        }

        private boolean diff(int depth, List<CompactionTree> nodes) {
            ParallelCompactor.this.gcListener.info("found {} nodes at depth {}.", new Object[]{nodes.size(), depth});
            if (nodes.size() >= 10000) {
                nodes.forEach(node -> node.compactAsync(this.hardCanceller, this.softCanceller));
                return true;
            }
            if (nodes.isEmpty()) {
                return true;
            }
            ArrayList<CompactionTree> nextDepth = new ArrayList<CompactionTree>();
            for (CompactionTree node2 : nodes) {
                long estimatedSize = node2.getEstimatedSize();
                if (estimatedSize != -1L && estimatedSize <= ParallelCompactor.this.totalSizeEstimate / (long)ParallelCompactor.this.numWorkers) {
                    node2.compactAsync(this.hardCanceller, this.softCanceller);
                    continue;
                }
                if (nextDepth.size() < 100000) {
                    List<Map.Entry<String, CompactionTree>> children = node2.expand(this.hardCanceller);
                    if (children == null) {
                        return false;
                    }
                    children.forEach(entry -> nextDepth.add((CompactionTree)entry.getValue()));
                    continue;
                }
                nextDepth.add(node2);
            }
            if (nextDepth.size() < nodes.size()) {
                nodes.forEach(node -> node.compactAsync(this.hardCanceller, this.softCanceller));
                return true;
            }
            return this.diff(depth + 1, nextDepth);
        }
    }

    private class CompactionTree
    implements NodeStateDiff {
        @NotNull
        private final NodeState before;
        @NotNull
        private final NodeState after;
        @NotNull
        private final NodeState onto;
        @NotNull
        private final List<Map.Entry<String, CompactionTree>> modifiedChildren = new ArrayList<Map.Entry<String, CompactionTree>>();
        @NotNull
        private final List<Property> modifiedProperties = new ArrayList<Property>();
        @NotNull
        private final List<String> removedChildNames = new ArrayList<String>();
        @NotNull
        private final List<String> removedPropertyNames = new ArrayList<String>();
        @Nullable
        private Future<CompactedNodeState> compactionFuture;

        CompactionTree(@NotNull NodeState before, @NotNull NodeState after, NodeState onto) {
            this.before = (NodeState)Preconditions.checkNotNull((Object)before);
            this.after = (NodeState)Preconditions.checkNotNull((Object)after);
            this.onto = (NodeState)Preconditions.checkNotNull((Object)onto);
        }

        private boolean compareState(@NotNull Canceller canceller) {
            return this.after.compareAgainstBaseState(this.before, (NodeStateDiff)new CancelableDiff(this, (Supplier<Boolean>)((Supplier)() -> canceller.check().isCancelled())));
        }

        @Nullable
        List<Map.Entry<String, CompactionTree>> expand(@NotNull Canceller hardCanceller) {
            Preconditions.checkState((this.compactionFuture == null ? 1 : 0) != 0);
            CompactedNodeState compactedState = ParallelCompactor.this.compactor.getPreviouslyCompactedState(this.after);
            if (compactedState != null) {
                this.compactionFuture = CompletableFuture.completedFuture(compactedState);
                return Collections.emptyList();
            }
            if (this.compareState(hardCanceller)) {
                return this.modifiedChildren;
            }
            return null;
        }

        long getEstimatedSize() {
            return ApproximateCounter.getCountSync(this.after);
        }

        public boolean propertyAdded(PropertyState after) {
            this.modifiedProperties.add(new Property(after));
            return true;
        }

        public boolean propertyChanged(PropertyState before, PropertyState after) {
            this.modifiedProperties.add(new Property(after));
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            this.removedPropertyNames.add(before.getName());
            return true;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            NodeState childOnto = this.onto.getChildNode(name);
            CompactionTree child = new CompactionTree(EmptyNodeState.EMPTY_NODE, after, childOnto.exists() ? childOnto : EmptyNodeState.EMPTY_NODE);
            this.modifiedChildren.add(new AbstractMap.SimpleImmutableEntry<String, CompactionTree>(name, child));
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            CompactionTree child = new CompactionTree(before, after, this.onto.getChildNode(name));
            this.modifiedChildren.add(new AbstractMap.SimpleImmutableEntry<String, CompactionTree>(name, child));
            return true;
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            this.removedChildNames.add(name);
            return true;
        }

        void compactAsync(@NotNull Canceller hardCanceller, @Nullable Canceller softCanceller) {
            if (this.compactionFuture == null) {
                Preconditions.checkNotNull((Object)ParallelCompactor.this.executorService);
                if (softCanceller == null) {
                    this.compactionFuture = ParallelCompactor.this.executorService.submit(() -> ParallelCompactor.this.compactor.compact(this.before, this.after, this.onto, hardCanceller));
                } else {
                    Preconditions.checkState((boolean)this.onto.equals(this.after));
                    this.compactionFuture = ParallelCompactor.this.executorService.submit(() -> ParallelCompactor.this.compactor.compactDown(this.before, this.after, hardCanceller, softCanceller));
                }
            }
        }

        private boolean tryCancelCompaction() {
            if (this.compactionFuture != null && this.compactionFuture.cancel(false)) {
                this.compactionFuture = null;
                return true;
            }
            return false;
        }

        @Nullable
        CompactedNodeState compact() throws IOException {
            if (this.compactionFuture != null) {
                try {
                    return this.compactionFuture.get();
                }
                catch (InterruptedException e) {
                    return null;
                }
                catch (ExecutionException e) {
                    throw new IOException(e);
                }
            }
            MemoryNodeBuilder builder = new MemoryNodeBuilder(this.onto);
            Buffer stableIdBytes = CompactorUtils.getStableIdBytes(this.after);
            for (int i = 0; i < this.modifiedChildren.size(); ++i) {
                Map.Entry<String, CompactionTree> entry = this.modifiedChildren.get(i);
                CompactionTree child = entry.getValue();
                CompactedNodeState compactedState = child.compact();
                if (compactedState == null) {
                    return null;
                }
                builder.setChildNode(entry.getKey(), (NodeState)compactedState);
                if (compactedState.isComplete()) continue;
                for (int j = this.modifiedChildren.size() - 1; j > i; --j) {
                    entry = this.modifiedChildren.get(j);
                    if (entry.getValue().tryCancelCompaction()) continue;
                    compactedState = entry.getValue().compact();
                    if (compactedState == null) {
                        return null;
                    }
                    builder.setChildNode(entry.getKey(), (NodeState)compactedState);
                }
                return ParallelCompactor.this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, false);
            }
            for (String name : this.removedChildNames) {
                builder.getChildNode(name).remove();
            }
            for (Property property : this.modifiedProperties) {
                builder.setProperty(property.compact());
            }
            for (String name : this.removedPropertyNames) {
                builder.removeProperty(name);
            }
            return ParallelCompactor.this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, true);
        }

        private class Property {
            @NotNull
            private final PropertyState state;

            Property(PropertyState state) {
                this.state = state;
            }

            @NotNull
            PropertyState compact() {
                return ParallelCompactor.this.compactor.compact(this.state);
            }
        }
    }
}

